/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.sofiainstance;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum State implements Enumerator
{
    ACTIVE(0, "active", "active"),
    INACTIVE(1, "inactive", "inactive"),
    EXECUTING(2, "executing", "executing"),
    EXECUTED(3, "executed", "executed"),
    PAUSED(4, "paused", "paused"),
    STOPPED(5, "stopped", "stopped"),
    FAILED(6, "failed", "failed"),
    KILLED(7, "killed", "killed"),
    WAITING(8, "waiting", "waiting"),
    UNDEPLOYED(9, "undeployed", "undeployed"),
    ESCALATED(10, "escalated", "escalated"),
    DEACTIVATED(11, "deactivated", "deactivated");

    public static final int ACTIVE_VALUE = 0;
    public static final int INACTIVE_VALUE = 1;
    public static final int EXECUTING_VALUE = 2;
    public static final int EXECUTED_VALUE = 3;
    public static final int PAUSED_VALUE = 4;
    public static final int STOPPED_VALUE = 5;
    public static final int FAILED_VALUE = 6;
    public static final int KILLED_VALUE = 7;
    public static final int WAITING_VALUE = 8;
    public static final int UNDEPLOYED_VALUE = 9;
    public static final int ESCALATED_VALUE = 10;
    public static final int DEACTIVATED_VALUE = 11;
    private static final State[] VALUES_ARRAY;
    public static final List<State> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new State[]{ACTIVE, INACTIVE, EXECUTING, EXECUTED, PAUSED, STOPPED, FAILED, KILLED, WAITING, UNDEPLOYED, ESCALATED, DEACTIVATED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static State get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            State result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static State getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            State result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static State get(int value) {
        switch (value) {
            case 0: {
                return ACTIVE;
            }
            case 1: {
                return INACTIVE;
            }
            case 2: {
                return EXECUTING;
            }
            case 3: {
                return EXECUTED;
            }
            case 4: {
                return PAUSED;
            }
            case 5: {
                return STOPPED;
            }
            case 6: {
                return FAILED;
            }
            case 7: {
                return KILLED;
            }
            case 8: {
                return WAITING;
            }
            case 9: {
                return UNDEPLOYED;
            }
            case 10: {
                return ESCALATED;
            }
            case 11: {
                return DEACTIVATED;
            }
        }
        return null;
    }

    private State(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

