/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.sofiainstance;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ExecutionPermission implements Enumerator
{
    DELAYED(0, "delayed", "delayed"),
    DENIED(1, "denied", "denied"),
    GRANTED(2, "granted", "granted"),
    SYNCHRONIZED(3, "synchronized", "synchronized");

    public static final int DELAYED_VALUE = 0;
    public static final int DENIED_VALUE = 1;
    public static final int GRANTED_VALUE = 2;
    public static final int SYNCHRONIZED_VALUE = 3;
    private static final ExecutionPermission[] VALUES_ARRAY;
    public static final List<ExecutionPermission> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ExecutionPermission[]{DELAYED, DENIED, GRANTED, SYNCHRONIZED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ExecutionPermission get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ExecutionPermission result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ExecutionPermission getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ExecutionPermission result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ExecutionPermission get(int value) {
        switch (value) {
            case 0: {
                return DELAYED;
            }
            case 1: {
                return DENIED;
            }
            case 2: {
                return GRANTED;
            }
            case 3: {
                return SYNCHRONIZED;
            }
        }
        return null;
    }

    private ExecutionPermission(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

