/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.sofia;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum HumanTaskType implements Enumerator
{
    HINT(0, "HINT", "HINT"),
    WARNING(1, "WARNING", "WARNING"),
    INTERACTION(2, "INTERACTION", "INTERACTION"),
    ERROR(3, "ERROR", "ERROR");

    public static final int HINT_VALUE = 0;
    public static final int WARNING_VALUE = 1;
    public static final int INTERACTION_VALUE = 2;
    public static final int ERROR_VALUE = 3;
    private static final HumanTaskType[] VALUES_ARRAY;
    public static final List<HumanTaskType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new HumanTaskType[]{HINT, WARNING, INTERACTION, ERROR};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static HumanTaskType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            HumanTaskType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static HumanTaskType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            HumanTaskType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static HumanTaskType get(int value) {
        switch (value) {
            case 0: {
                return HINT;
            }
            case 1: {
                return WARNING;
            }
            case 2: {
                return INTERACTION;
            }
            case 3: {
                return ERROR;
            }
        }
        return null;
    }

    private HumanTaskType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

