/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.sofia;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Comparator implements Enumerator
{
    GREATER_THAN(0, "GreaterThan", "GreaterThan"),
    SMALLER_THAN(1, "SmallerThan", "SmallerThan"),
    GREATER_THAN_OR_EQUAL(2, "GreaterThanOrEqual", "GreaterThanOrEqual"),
    SMALLER_THAN_OR_EQUAL(3, "SmallerThanOrEqual", "SmallerThanOrEqual"),
    EQUAL(4, "Equal", "Equal"),
    DISTINCT(5, "Distinct", "Distinct"),
    IDENTIC(6, "Identic", "Identic");

    public static final int GREATER_THAN_VALUE = 0;
    public static final int SMALLER_THAN_VALUE = 1;
    public static final int GREATER_THAN_OR_EQUAL_VALUE = 2;
    public static final int SMALLER_THAN_OR_EQUAL_VALUE = 3;
    public static final int EQUAL_VALUE = 4;
    public static final int DISTINCT_VALUE = 5;
    public static final int IDENTIC_VALUE = 6;
    private static final Comparator[] VALUES_ARRAY;
    public static final List<Comparator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Comparator[]{GREATER_THAN, SMALLER_THAN, GREATER_THAN_OR_EQUAL, SMALLER_THAN_OR_EQUAL, EQUAL, DISTINCT, IDENTIC};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Comparator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Comparator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Comparator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Comparator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Comparator get(int value) {
        switch (value) {
            case 0: {
                return GREATER_THAN;
            }
            case 1: {
                return SMALLER_THAN;
            }
            case 2: {
                return GREATER_THAN_OR_EQUAL;
            }
            case 3: {
                return SMALLER_THAN_OR_EQUAL;
            }
            case 4: {
                return EQUAL;
            }
            case 5: {
                return DISTINCT;
            }
            case 6: {
                return IDENTIC;
            }
        }
        return null;
    }

    private Comparator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

