/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.util.serialization.jsontypes;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import eu.vicci.process.model.sofia.BooleanType;
import eu.vicci.process.model.sofia.ComplexType;
import eu.vicci.process.model.sofia.DataType;
import eu.vicci.process.model.sofia.DoubleType;
import eu.vicci.process.model.sofia.IntegerType;
import eu.vicci.process.model.sofia.ListType;
import eu.vicci.process.model.sofia.SetType;
import eu.vicci.process.model.sofia.StringType;
import eu.vicci.process.model.util.serialization.JSONSerializer;
import eu.vicci.process.model.util.serialization.jsontypes.JSONBooleanType;
import eu.vicci.process.model.util.serialization.jsontypes.JSONComplexType;
import eu.vicci.process.model.util.serialization.jsontypes.JSONDoubleType;
import eu.vicci.process.model.util.serialization.jsontypes.JSONIntegerType;
import eu.vicci.process.model.util.serialization.jsontypes.JSONListType;
import eu.vicci.process.model.util.serialization.jsontypes.JSONSetType;
import eu.vicci.process.model.util.serialization.jsontypes.JSONStringType;
import eu.vicci.process.model.util.serialization.jsontypes.core.DataTypeType;
import eu.vicci.process.model.util.serialization.jsontypes.core.IJSONType;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@id")
@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="@class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=JSONIntegerType.class, name="JSONIntegerType"), @JsonSubTypes.Type(value=JSONStringType.class, name="JSONStringType"), @JsonSubTypes.Type(value=JSONBooleanType.class, name="JSONBooleanType"), @JsonSubTypes.Type(value=JSONDoubleType.class, name="JSONDoubleType"), @JsonSubTypes.Type(value=JSONListType.class, name="JSONListType"), @JsonSubTypes.Type(value=JSONComplexType.class, name="JSONComplexType"), @JsonSubTypes.Type(value=JSONSetType.class, name="JSONSetType")})
public abstract class JSONType
implements IJSONType {
    private String name;
    private String id;
    private String typeClass;
    private DataTypeType dataTypeType;

    public JSONType() {
    }

    public JSONType(DataType dataType) {
        this.name = dataType.getName();
        this.id = dataType.getId();
        this.typeClass = this.getClass().getCanonicalName();
        this.setPrivateDataTypeType(dataType);
        JSONSerializer.addToProcessed(this.id, this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String instanceID) {
        this.id = instanceID;
    }

    public String getTypeClass() {
        return this.typeClass;
    }

    public void setTypeClass(String className) {
        this.typeClass = className;
    }

    public abstract DataType makeDataType();

    protected void addBaseInformationsToDataType(DataType dti) {
        dti.setId(this.id);
        dti.setName(this.name);
    }

    protected void copyBaseInformationsToJson(IJSONType type) {
        type.setID(this.id);
        type.setName(this.name);
        type.setDataTypeType(this.dataTypeType);
    }

    public DataTypeType getDataTypeType() {
        return this.dataTypeType;
    }

    public void setDataTypeType(DataTypeType dataTypeType) {
        this.dataTypeType = dataTypeType;
    }

    private void setPrivateDataTypeType(DataType dataType) {
        if (dataType instanceof StringType) {
            this.dataTypeType = DataTypeType.StringType;
        } else if (dataType instanceof DoubleType) {
            this.dataTypeType = DataTypeType.DoubleType;
        } else if (dataType instanceof BooleanType) {
            this.dataTypeType = DataTypeType.BooleanType;
        } else if (dataType instanceof SetType) {
            this.dataTypeType = DataTypeType.SetType;
        } else if (dataType instanceof ComplexType) {
            this.dataTypeType = DataTypeType.ComplexType;
        } else if (dataType instanceof IntegerType) {
            this.dataTypeType = DataTypeType.IntegerType;
        } else if (dataType instanceof ListType) {
            this.dataTypeType = DataTypeType.ListType;
        } else {
            throw new IllegalArgumentException("Not know type for serialization dto: " + dataType.getClass());
        }
    }
}

