/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.util.serialization.jsontypes;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import eu.vicci.process.model.sofia.DataMapping;
import eu.vicci.process.model.sofia.SofiaFactory;
import eu.vicci.process.model.util.serialization.JSONSerializer;
import eu.vicci.process.model.util.serialization.jsontypes.JSONType;
import eu.vicci.process.model.util.serialization.jsontypes.core.IJSONType;

public class JSONMapping {
    private String id;
    private String name;
    @JsonDeserialize(as=JSONType.class)
    private IJSONType source;
    @JsonDeserialize(as=JSONType.class)
    private IJSONType target;

    public JSONMapping(DataMapping mapping) {
        this.id = mapping.getId();
        this.name = mapping.getName();
        String sourceId = mapping.getSource().getId();
        String targetId = mapping.getTarget().getId();
        if (!JSONSerializer.hasProcessed(sourceId)) {
            JSONSerializer.addToProcessed(sourceId, mapping.getSource());
            this.source = (IJSONType)JSONSerializer.getProcessed(sourceId);
        }
        if (!JSONSerializer.hasProcessed(targetId)) {
            JSONSerializer.addToProcessed(targetId, mapping.getTarget());
            this.target = (IJSONType)JSONSerializer.getProcessed(targetId);
        }
    }

    public DataMapping makeMapping() {
        DataMapping result = SofiaFactory.eINSTANCE.createDataMapping();
        result.setId(this.id);
        result.setName(this.name);
        result.setSource(this.source.makeDataType());
        result.setTarget(this.target.makeDataType());
        return result;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IJSONType getSource() {
        return this.source;
    }

    public void setSource(IJSONType source) {
        this.source = source;
    }

    public IJSONType getTarget() {
        return this.target;
    }

    public void setTarget(IJSONType target) {
        this.target = target;
    }
}

