/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.util.serialization.jsontypes;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import eu.vicci.process.model.sofia.DataType;
import eu.vicci.process.model.sofia.ListType;
import eu.vicci.process.model.sofia.SofiaFactory;
import eu.vicci.process.model.util.serialization.jsontypes.JSONType;
import eu.vicci.process.model.util.serialization.jsontypes.JSONTypeSerializer;
import eu.vicci.process.model.util.serialization.jsontypes.core.IJSONListType;
import eu.vicci.process.model.util.serialization.jsontypes.core.IJSONType;

public class JSONListType
extends JSONType
implements IJSONListType {
    @JsonDeserialize(as=JSONType.class)
    private IJSONType collectionType;

    public JSONListType() {
    }

    public JSONListType(ListType listType) {
        super((DataType)listType);
        this.collectionType = JSONTypeSerializer.makeJSONType(listType.getCollectionItemType());
    }

    public ListType makeDataType() {
        ListType lti = SofiaFactory.eINSTANCE.createListType();
        this.addBaseInformationsToDataType((DataType)lti);
        lti.setCollectionItemType(this.collectionType.makeDataType());
        return lti;
    }

    public IJSONType getCollectionType() {
        return this.collectionType;
    }

    public void setCollectionType(IJSONType collectionType) {
        this.collectionType = collectionType;
    }

    public IJSONListType makeCopy() {
        JSONListType copy = new JSONListType();
        this.copyBaseInformationsToJson(copy);
        copy.setCollectionType(this.collectionType.makeCopy());
        return copy;
    }
}

