/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.util.serialization.jsontypes;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import eu.vicci.process.model.sofia.BooleanType;
import eu.vicci.process.model.sofia.ComplexType;
import eu.vicci.process.model.sofia.DataType;
import eu.vicci.process.model.sofia.DoubleType;
import eu.vicci.process.model.sofia.IntegerType;
import eu.vicci.process.model.sofia.ListType;
import eu.vicci.process.model.sofia.SofiaFactory;
import eu.vicci.process.model.sofia.StringType;
import eu.vicci.process.model.util.serialization.jsontypes.JSONBooleanType;
import eu.vicci.process.model.util.serialization.jsontypes.JSONDoubleType;
import eu.vicci.process.model.util.serialization.jsontypes.JSONIntegerType;
import eu.vicci.process.model.util.serialization.jsontypes.JSONListType;
import eu.vicci.process.model.util.serialization.jsontypes.JSONStringType;
import eu.vicci.process.model.util.serialization.jsontypes.JSONType;
import eu.vicci.process.model.util.serialization.jsontypes.core.IJSONComplexType;
import eu.vicci.process.model.util.serialization.jsontypes.core.IJSONType;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;

public class JSONComplexType
extends JSONType
implements IJSONComplexType {
    @JsonDeserialize(contentAs=JSONType.class)
    private List<IJSONType> subTypes = new ArrayList<IJSONType>();

    public JSONComplexType() {
    }

    public JSONComplexType(ComplexType complexType) {
        super((DataType)complexType);
        this.addSubTypes(complexType);
    }

    private Class<?> getItemType(DataType subType) {
        if (subType instanceof IntegerType) {
            return JSONIntegerType.class;
        }
        if (subType instanceof StringType) {
            return JSONStringType.class;
        }
        if (subType instanceof BooleanType) {
            return JSONBooleanType.class;
        }
        if (subType instanceof DoubleType) {
            return JSONDoubleType.class;
        }
        if (subType instanceof ListType) {
            return JSONListType.class;
        }
        if (subType instanceof ComplexType) {
            return JSONComplexType.class;
        }
        throw new IllegalArgumentException("type currently not supported for serialization: " + subType.getClass().getCanonicalName());
    }

    private void addSubTypes(ComplexType complexType) {
        try {
            block2: for (DataType subType : complexType.getSubtypes()) {
                Constructor<?>[] constructors;
                Constructor<?>[] constructorArray = constructors = this.getItemType(subType).getConstructors();
                int n = constructors.length;
                int n2 = 0;
                while (n2 < n) {
                    Constructor<?> constructor = constructorArray[n2];
                    if (constructor.getParameterTypes().length == 1) {
                        this.subTypes.add((JSONType)constructor.newInstance(subType));
                        continue block2;
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            System.err.println("missing constructor for subtype of JSONType");
            e.printStackTrace();
        }
    }

    @Override
    public DataType makeDataType() {
        ComplexType ct = SofiaFactory.eINSTANCE.createComplexType();
        for (IJSONType subType : this.subTypes) {
            ct.getSubtypes().add((Object)subType.makeDataType());
        }
        this.addBaseInformationsToDataType((DataType)ct);
        this.addBelongsTo(ct);
        return ct;
    }

    public String toString() {
        String subTypeString = "";
        for (IJSONType subType : this.subTypes) {
            subTypeString = String.valueOf(subTypeString) + subType.toString() + "\n";
        }
        return String.valueOf(this.getClass().getSimpleName()) + "[ Elements: {\n" + subTypeString + "}, ID:" + this.getID() + "]";
    }

    public List<IJSONType> getSubTypes() {
        return this.subTypes;
    }

    public void setSubTypes(List<IJSONType> subTypes) {
        this.subTypes = subTypes;
    }

    public IJSONComplexType makeCopy() {
        JSONComplexType copy = new JSONComplexType();
        this.copyBaseInformationsToJson(copy);
        this.copySubTypes(copy);
        return copy;
    }

    private void copySubTypes(IJSONComplexType newInstance) {
        ArrayList<IJSONType> subs = new ArrayList<IJSONType>();
        for (IJSONType sub : this.subTypes) {
            subs.add(sub.makeCopy());
        }
        newInstance.setSubTypes(subs);
    }

    private void addBelongsTo(ComplexType ct) {
        for (DataType type : ct.getSubtypes()) {
            type.setBelongsTo(ct);
        }
    }
}

