/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.util.serialization.jsontypeinstances;

import eu.vicci.process.model.util.serialization.jsontypeinstances.JSONBooleanTypeInstance;
import eu.vicci.process.model.util.serialization.jsontypeinstances.JSONDoubleTypeInstance;
import eu.vicci.process.model.util.serialization.jsontypeinstances.JSONIntegerTypeInstance;
import eu.vicci.process.model.util.serialization.jsontypeinstances.JSONStringTypeInstance;
import eu.vicci.process.model.util.serialization.jsontypeinstances.core.DataTypeInstanceType;
import eu.vicci.process.model.util.serialization.jsontypeinstances.core.IJSONBooleanTypeInstance;
import eu.vicci.process.model.util.serialization.jsontypeinstances.core.IJSONDoubleTypeInstance;
import eu.vicci.process.model.util.serialization.jsontypeinstances.core.IJSONIntegerTypeInstance;
import eu.vicci.process.model.util.serialization.jsontypeinstances.core.IJSONStringTypeInstance;
import eu.vicci.process.model.util.serialization.jsontypeinstances.core.IJSONTypeInstance;
import eu.vicci.process.model.util.serialization.jsontypes.core.IJSONBooleanType;
import eu.vicci.process.model.util.serialization.jsontypes.core.IJSONDoubleType;
import eu.vicci.process.model.util.serialization.jsontypes.core.IJSONIntegerType;
import eu.vicci.process.model.util.serialization.jsontypes.core.IJSONStringType;
import eu.vicci.process.model.util.serialization.jsontypes.core.IJSONType;

public class JSONTypeInstanceUtil {
    private static final String INSTANCE_SUFFIX = "_instance_";

    public static IJSONIntegerTypeInstance createIntegerTypeInstance(IJSONIntegerType type, int instanceNumber) {
        JSONIntegerTypeInstance newInstance = new JSONIntegerTypeInstance();
        JSONTypeInstanceUtil.copyBase((IJSONType)type, newInstance, instanceNumber);
        newInstance.setDataTypeInstanceType(DataTypeInstanceType.IntegerTypeInstance);
        return newInstance;
    }

    public static IJSONDoubleTypeInstance createDoubleTypeInstance(IJSONDoubleType type, int instanceNumber) {
        JSONDoubleTypeInstance newInstance = new JSONDoubleTypeInstance();
        JSONTypeInstanceUtil.copyBase((IJSONType)type, newInstance, instanceNumber);
        newInstance.setDataTypeInstanceType(DataTypeInstanceType.DoubleTypeInstance);
        return newInstance;
    }

    public static IJSONStringTypeInstance createStringTypeInstance(IJSONStringType type, int instanceNumber) {
        JSONStringTypeInstance newInstance = new JSONStringTypeInstance();
        JSONTypeInstanceUtil.copyBase((IJSONType)type, newInstance, instanceNumber);
        newInstance.setDataTypeInstanceType(DataTypeInstanceType.StringTypeInstance);
        return newInstance;
    }

    public static IJSONBooleanTypeInstance createBooleanTypeInstance(IJSONBooleanType type, int instanceNumber) {
        JSONBooleanTypeInstance newInstance = new JSONBooleanTypeInstance();
        JSONTypeInstanceUtil.copyBase((IJSONType)type, newInstance, instanceNumber);
        newInstance.setDataTypeInstanceType(DataTypeInstanceType.StringTypeInstance);
        return newInstance;
    }

    private static void copyBase(IJSONType type, IJSONTypeInstance typeInstance, int instanceNumber) {
        typeInstance.setDataType(type);
        typeInstance.setDataTypeID(type.getID());
        typeInstance.setInstanceID(String.valueOf(type.getID()) + INSTANCE_SUFFIX + instanceNumber);
        typeInstance.setName(type.getName());
    }

    public static IJSONTypeInstance createTypeInstance(IJSONType type, int instanceNumber) {
        IJSONStringTypeInstance newInstance = null;
        switch (type.getDataTypeType()) {
            case StringType: {
                newInstance = JSONTypeInstanceUtil.createStringTypeInstance((IJSONStringType)type, instanceNumber);
                break;
            }
            case DoubleType: {
                newInstance = JSONTypeInstanceUtil.createDoubleTypeInstance((IJSONDoubleType)type, instanceNumber);
                break;
            }
            case IntegerType: {
                newInstance = JSONTypeInstanceUtil.createIntegerTypeInstance((IJSONIntegerType)type, instanceNumber);
                break;
            }
            case BooleanType: {
                newInstance = JSONTypeInstanceUtil.createBooleanTypeInstance((IJSONBooleanType)type, instanceNumber);
                break;
            }
            default: {
                throw new IllegalArgumentException("currently not supported type: " + type.getDataTypeType().name());
            }
        }
        JSONTypeInstanceUtil.copyBase(type, (IJSONTypeInstance)newInstance, instanceNumber);
        return newInstance;
    }
}

