/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.util.serialization.jsontypeinstances;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import eu.vicci.process.model.sofiainstance.BooleanTypeInstance;
import eu.vicci.process.model.sofiainstance.ComplexTypeInstance;
import eu.vicci.process.model.sofiainstance.DataTypeInstance;
import eu.vicci.process.model.sofiainstance.DoubleTypeInstance;
import eu.vicci.process.model.sofiainstance.IntegerTypeInstance;
import eu.vicci.process.model.sofiainstance.ListTypeInstance;
import eu.vicci.process.model.sofiainstance.SetTypeInstance;
import eu.vicci.process.model.sofiainstance.SofiaInstanceFactory;
import eu.vicci.process.model.sofiainstance.StringTypeInstance;
import eu.vicci.process.model.util.serialization.jsontypeinstances.JSONBooleanTypeInstance;
import eu.vicci.process.model.util.serialization.jsontypeinstances.JSONComplexTypeInstance;
import eu.vicci.process.model.util.serialization.jsontypeinstances.JSONDoubleTypeInstance;
import eu.vicci.process.model.util.serialization.jsontypeinstances.JSONIntegerTypeInstance;
import eu.vicci.process.model.util.serialization.jsontypeinstances.JSONListTypeInstance;
import eu.vicci.process.model.util.serialization.jsontypeinstances.JSONSetTypeInstance;
import eu.vicci.process.model.util.serialization.jsontypeinstances.JSONStringTypeInstance;
import eu.vicci.process.model.util.serialization.jsontypeinstances.core.DataTypeInstanceType;
import eu.vicci.process.model.util.serialization.jsontypeinstances.core.IJSONTypeInstance;
import eu.vicci.process.model.util.serialization.jsontypes.JSONType;
import eu.vicci.process.model.util.serialization.jsontypes.JSONTypeSerializer;
import eu.vicci.process.model.util.serialization.jsontypes.core.IJSONType;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@id")
@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="@class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=JSONIntegerTypeInstance.class, name="JSONIntegerTypeInstance"), @JsonSubTypes.Type(value=JSONStringTypeInstance.class, name="JSONStringTypeInstance"), @JsonSubTypes.Type(value=JSONBooleanTypeInstance.class, name="JSONBooleanTypeInstance"), @JsonSubTypes.Type(value=JSONDoubleTypeInstance.class, name="JSONDoubleTypeInstance"), @JsonSubTypes.Type(value=JSONListTypeInstance.class, name="JSONListTypeInstance"), @JsonSubTypes.Type(value=JSONComplexTypeInstance.class, name="JSONComplexTypeInstance"), @JsonSubTypes.Type(value=JSONSetTypeInstance.class, name="JSONSetTypeInstance")})
public abstract class JSONTypeInstance
implements IJSONTypeInstance {
    private String name;
    private String dataTypeID;
    private String instanceID;
    @Deprecated
    private String typeClass;
    private DataTypeInstanceType dataTypeInstanceType;
    @JsonDeserialize(as=JSONType.class)
    private IJSONType dataType;

    public JSONTypeInstance() {
    }

    public JSONTypeInstance(DataTypeInstance dataType) {
        this.name = dataType.getName();
        this.dataTypeID = dataType.getTypeId();
        this.instanceID = dataType.getInstanceId();
        this.typeClass = this.getClass().getCanonicalName();
        this.setDataTypeInstanceAndDataType(dataType);
    }

    public String getDataTypeID() {
        return this.dataTypeID;
    }

    public void setDataTypeID(String dataTypeID) {
        this.dataTypeID = dataTypeID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getInstanceID() {
        return this.instanceID;
    }

    public void setInstanceID(String instanceID) {
        this.instanceID = instanceID;
    }

    public String getTypeClass() {
        return this.typeClass;
    }

    public void setTypeClass(String className) {
        this.typeClass = className;
    }

    public abstract DataTypeInstance makeDataTypeInstance(SofiaInstanceFactory var1);

    @JsonIgnore
    public abstract Object getValueAsObject();

    protected void addBaseInformationsToDataTypeInstance(DataTypeInstance dti) {
        dti.setInstanceId(this.instanceID);
        dti.setName(this.name);
        dti.setTypeId(this.dataTypeID);
        dti.setDataTypeType(this.dataType.makeDataType());
    }

    protected void copyBaseInformationsToJson(IJSONTypeInstance newInstance) {
        newInstance.setInstanceID(this.instanceID);
        newInstance.setName(this.name);
        newInstance.setDataTypeID(this.dataTypeID);
        newInstance.setDataTypeInstanceType(this.dataTypeInstanceType);
        newInstance.setDataType(this.dataType.makeCopy());
    }

    @JsonIgnore
    public String getValueString() {
        return this.getValueStringComplete().replace("_instance", "");
    }

    @JsonIgnore
    public abstract String getValueStringComplete();

    public DataTypeInstanceType getDataTypeInstanceType() {
        return this.dataTypeInstanceType;
    }

    public void setDataTypeInstanceType(DataTypeInstanceType dataTypeInstanceType) {
        this.dataTypeInstanceType = dataTypeInstanceType;
    }

    private void setDataTypeInstanceAndDataType(DataTypeInstance dataTypeInstance) {
        if (dataTypeInstance instanceof StringTypeInstance) {
            this.dataTypeInstanceType = DataTypeInstanceType.StringTypeInstance;
        } else if (dataTypeInstance instanceof DoubleTypeInstance) {
            this.dataTypeInstanceType = DataTypeInstanceType.DoubleTypeInstance;
        } else if (dataTypeInstance instanceof BooleanTypeInstance) {
            this.dataTypeInstanceType = DataTypeInstanceType.BooleanTypeInstance;
        } else if (dataTypeInstance instanceof SetTypeInstance) {
            this.dataTypeInstanceType = DataTypeInstanceType.SetTypeInstance;
        } else if (dataTypeInstance instanceof ComplexTypeInstance) {
            this.dataTypeInstanceType = DataTypeInstanceType.ComplexTypeInstance;
        } else if (dataTypeInstance instanceof IntegerTypeInstance) {
            this.dataTypeInstanceType = DataTypeInstanceType.IntegerTypeInstance;
        } else if (dataTypeInstance instanceof ListTypeInstance) {
            this.dataTypeInstanceType = DataTypeInstanceType.ListTypeInstance;
        } else {
            throw new IllegalArgumentException("Not know type for serialization dto: " + dataTypeInstance.getClass());
        }
        this.dataType = JSONTypeSerializer.makeJSONType(dataTypeInstance.getDataTypeType());
    }

    public IJSONType getDataType() {
        return this.dataType;
    }

    public void setDataType(IJSONType dataType) {
        this.dataType = dataType;
    }
}

