/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.util.serialization.jsontypeinstances;

import eu.vicci.process.model.sofiainstance.DataTypeInstance;
import eu.vicci.process.model.sofiainstance.SofiaInstanceFactory;
import eu.vicci.process.model.sofiainstance.StringTypeInstance;
import eu.vicci.process.model.util.serialization.jsontypeinstances.JSONTypeInstance;
import eu.vicci.process.model.util.serialization.jsontypeinstances.core.IJSONStringTypeInstance;

public class JSONStringTypeInstance
extends JSONTypeInstance
implements IJSONStringTypeInstance {
    private String value;

    public JSONStringTypeInstance() {
    }

    public JSONStringTypeInstance(StringTypeInstance stringType) {
        super((DataTypeInstance)stringType);
        this.value = stringType.getValue();
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public String getValueAsObject() {
        return this.value;
    }

    public StringTypeInstance makeDataTypeInstance(SofiaInstanceFactory instanceFactory) {
        StringTypeInstance sti = instanceFactory.createStringTypeInstance();
        sti.setValue(this.value);
        this.addBaseInformationsToDataTypeInstance((DataTypeInstance)sti);
        return sti;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[ Value: " + this.value + ", InstanceID:" + this.getInstanceID() + "]";
    }

    @Override
    public String getValueStringComplete() {
        return String.valueOf(this.getName()) + ": " + this.value;
    }

    @Override
    public String getValueString() {
        return this.value;
    }

    public IJSONStringTypeInstance makeCopy() {
        JSONStringTypeInstance copy = new JSONStringTypeInstance();
        this.copyBaseInformationsToJson(copy);
        copy.setValue(this.value);
        return copy;
    }

    public void parseValue(String value) throws IllegalArgumentException {
        this.value = value;
    }
}

