/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.util.serialization.jsontypeinstances;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import eu.vicci.process.model.sofiainstance.DataTypeInstance;
import eu.vicci.process.model.sofiainstance.SetTypeInstance;
import eu.vicci.process.model.sofiainstance.SofiaInstanceFactory;
import eu.vicci.process.model.util.serialization.jsontypeinstances.JSONTypeInstance;
import eu.vicci.process.model.util.serialization.jsontypeinstances.core.IJSONSetTypeInstance;
import eu.vicci.process.model.util.serialization.jsontypeinstances.core.IJSONTypeInstance;
import java.util.LinkedHashSet;
import java.util.Set;

public class JSONSetTypeInstance
extends JSONTypeInstance
implements IJSONSetTypeInstance {
    @JsonDeserialize(as=LinkedHashSet.class, contentAs=JSONTypeInstance.class)
    private Set<IJSONTypeInstance> subTypes;

    public JSONSetTypeInstance() {
    }

    public JSONSetTypeInstance(SetTypeInstance dataTypeInstance) {
        super((DataTypeInstance)dataTypeInstance);
    }

    public SetTypeInstance makeDataTypeInstance(SofiaInstanceFactory instanceFactory) {
        SetTypeInstance setTypeInstance = instanceFactory.createSetTypeInstance();
        this.addBaseInformationsToDataTypeInstance((DataTypeInstance)setTypeInstance);
        return setTypeInstance;
    }

    @Override
    public Set<IJSONTypeInstance> getValueAsObject() {
        return this.subTypes;
    }

    public String toString() {
        String subTypeString = "";
        for (IJSONTypeInstance subType : this.subTypes) {
            subTypeString = String.valueOf(subTypeString) + subType.toString() + "\n";
        }
        return String.valueOf(this.getClass().getSimpleName()) + "[ Elements: {\n" + subTypeString + "}, InstanceID:" + this.getInstanceID() + "]";
    }

    @Override
    public String getValueStringComplete() {
        String result = "";
        for (IJSONTypeInstance item : this.subTypes) {
            result = String.valueOf(result) + item.getValueStringComplete() + ", ";
        }
        if (result.endsWith(", ")) {
            result = result.substring(0, result.length() - 2);
        }
        return result;
    }

    @Override
    public String getValueString() {
        String result = "";
        for (IJSONTypeInstance item : this.subTypes) {
            result = String.valueOf(result) + item.getValueString() + ", ";
        }
        if (result.endsWith(", ")) {
            result = result.substring(0, result.length() - 2);
        }
        return result;
    }

    public Set<IJSONTypeInstance> getSubTypes() {
        return this.subTypes;
    }

    public void setSubTypes(Set<IJSONTypeInstance> subTypes) {
        this.subTypes = subTypes;
    }

    public IJSONSetTypeInstance makeCopy() {
        JSONSetTypeInstance copy = new JSONSetTypeInstance();
        this.copyBaseInformationsToJson(copy);
        this.copySubTypes(copy);
        return copy;
    }

    private void copySubTypes(IJSONSetTypeInstance newInstance) {
        LinkedHashSet<IJSONTypeInstance> newSubs = new LinkedHashSet<IJSONTypeInstance>();
        for (IJSONTypeInstance sub : this.subTypes) {
            newSubs.add(sub.makeCopy());
        }
        newInstance.setSubTypes(newSubs);
    }

    public void parseValue(String value) throws IllegalArgumentException {
        throw new IllegalArgumentException("String cannot be parsed to a set at the moment");
    }
}

