/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.util.serialization.jsontypeinstances;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import eu.vicci.process.model.sofia.CollectionType;
import eu.vicci.process.model.sofia.DataType;
import eu.vicci.process.model.sofiainstance.DataTypeInstance;
import eu.vicci.process.model.sofiainstance.ListTypeInstance;
import eu.vicci.process.model.sofiainstance.SofiaInstanceFactory;
import eu.vicci.process.model.util.serialization.jsontypeinstances.JSONTypeInstance;
import eu.vicci.process.model.util.serialization.jsontypeinstances.JSONTypeInstanceSerializer;
import eu.vicci.process.model.util.serialization.jsontypeinstances.core.IJSONListTypeInstance;
import eu.vicci.process.model.util.serialization.jsontypeinstances.core.IJSONTypeInstance;
import eu.vicci.process.model.util.serialization.jsontypes.JSONType;
import eu.vicci.process.model.util.serialization.jsontypes.JSONTypeSerializer;
import eu.vicci.process.model.util.serialization.jsontypes.core.IJSONListType;
import eu.vicci.process.model.util.serialization.jsontypes.core.IJSONType;
import java.util.ArrayList;
import java.util.List;

public class JSONListTypeInstance
extends JSONTypeInstance
implements IJSONListTypeInstance {
    @JsonDeserialize(contentAs=JSONTypeInstance.class)
    private List<IJSONTypeInstance> subTypes = new ArrayList<IJSONTypeInstance>();
    @JsonDeserialize(as=JSONType.class)
    private IJSONType collectionType;

    public JSONListTypeInstance() {
    }

    public JSONListTypeInstance(ListTypeInstance listType) {
        super((DataTypeInstance)listType);
        DataType collectionTypeDT = this.detectCollectionItemType(listType);
        if (collectionTypeDT == null) {
            throw new IllegalArgumentException("the collection item type should not be null");
        }
        this.collectionType = JSONTypeSerializer.makeJSONType(collectionTypeDT);
        this.addSubTypes(listType);
    }

    private DataType detectCollectionItemType(ListTypeInstance listType) {
        DataType dt = listType.getCollectionItemType();
        if (dt == null) {
            dt = ((CollectionType)listType.getDataTypeType()).getCollectionItemType();
        }
        return dt;
    }

    private void addSubTypes(ListTypeInstance listType) {
        for (DataTypeInstance dataTypeInstance : listType.getSubtypes()) {
            this.subTypes.add(JSONTypeInstanceSerializer.makeJSONTypeInstance(dataTypeInstance));
        }
    }

    public List<IJSONTypeInstance> getSubTypes() {
        return this.subTypes;
    }

    public void setSubTypes(List<IJSONTypeInstance> list) {
        this.subTypes = list;
    }

    @Override
    public List<IJSONTypeInstance> getValueAsObject() {
        return this.subTypes;
    }

    public IJSONListType getDataType() {
        return (IJSONListType)super.getDataType();
    }

    public ListTypeInstance makeDataTypeInstance(SofiaInstanceFactory instanceFactory) {
        ListTypeInstance lti = instanceFactory.createListTypeInstance();
        for (IJSONTypeInstance subType : this.subTypes) {
            lti.getSubtypes().add((Object)subType.makeDataTypeInstance(instanceFactory));
        }
        lti.setCollectionItemType(this.collectionType.makeDataType());
        this.addBaseInformationsToDataTypeInstance((DataTypeInstance)lti);
        return lti;
    }

    public String toString() {
        String subTypeString = "";
        for (IJSONTypeInstance subType : this.subTypes) {
            subTypeString = String.valueOf(subTypeString) + subType.toString() + "\n";
        }
        return String.valueOf(this.getClass().getSimpleName()) + "[ Elements: {\n" + subTypeString + "}, InstanceID:" + this.getInstanceID() + "]";
    }

    @Override
    public String getValueStringComplete() {
        String result = "";
        for (IJSONTypeInstance item : this.subTypes) {
            result = String.valueOf(result) + item.getValueStringComplete() + ", ";
        }
        if (result.endsWith(", ")) {
            result = result.substring(0, result.length() - 2);
        }
        return result;
    }

    @Override
    public String getValueString() {
        String result = "";
        for (IJSONTypeInstance item : this.subTypes) {
            result = String.valueOf(result) + item.getValueString() + ", ";
        }
        if (result.endsWith(", ")) {
            result = result.substring(0, result.length() - 2);
        }
        return result;
    }

    public IJSONType getCollectionType() {
        return this.collectionType;
    }

    public void setCollectionType(IJSONType collectionType) {
        this.collectionType = collectionType;
    }

    public IJSONListTypeInstance makeCopy() {
        JSONListTypeInstance copy = new JSONListTypeInstance();
        this.copyBaseInformationsToJson(copy);
        this.copySubTypes(copy);
        copy.setCollectionType(this.collectionType.makeCopy());
        return copy;
    }

    public void parseValue(String value) throws IllegalArgumentException {
        throw new IllegalArgumentException("String cannot be parsed to a list at the moment");
    }

    private void copySubTypes(IJSONListTypeInstance newInstance) {
        ArrayList<IJSONTypeInstance> newSubs = new ArrayList<IJSONTypeInstance>();
        for (IJSONTypeInstance sub : this.subTypes) {
            newSubs.add(sub.makeCopy());
        }
        newInstance.setSubTypes(newSubs);
    }
}

