/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.util.serialization.jsontypeinstances;

import eu.vicci.process.model.sofiainstance.DataTypeInstance;
import eu.vicci.process.model.sofiainstance.IntegerTypeInstance;
import eu.vicci.process.model.sofiainstance.SofiaInstanceFactory;
import eu.vicci.process.model.util.serialization.jsontypeinstances.JSONTypeInstance;
import eu.vicci.process.model.util.serialization.jsontypeinstances.core.IJSONIntegerTypeInstance;

public class JSONIntegerTypeInstance
extends JSONTypeInstance
implements IJSONIntegerTypeInstance {
    private int value;

    public JSONIntegerTypeInstance() {
    }

    public JSONIntegerTypeInstance(IntegerTypeInstance integerType) {
        super((DataTypeInstance)integerType);
        this.value = integerType.getValue();
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    @Override
    public Integer getValueAsObject() {
        return this.value;
    }

    public IntegerTypeInstance makeDataTypeInstance(SofiaInstanceFactory instanceFactory) {
        IntegerTypeInstance iti = instanceFactory.createIntegerTypeInstance();
        iti.setValue(this.value);
        this.addBaseInformationsToDataTypeInstance((DataTypeInstance)iti);
        return iti;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[ Value: " + this.value + ", InstanceID:" + this.getInstanceID() + "]";
    }

    @Override
    public String getValueStringComplete() {
        return String.valueOf(this.getName()) + ": " + this.value;
    }

    @Override
    public String getValueString() {
        return String.valueOf(this.value);
    }

    public IJSONIntegerTypeInstance makeCopy() {
        JSONIntegerTypeInstance copy = new JSONIntegerTypeInstance();
        this.copyBaseInformationsToJson(copy);
        copy.setValue(this.value);
        return copy;
    }

    public void parseValue(String value) throws IllegalArgumentException {
        this.value = Integer.valueOf(value);
    }
}

