/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.util.serialization.jsontypeinstances;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import eu.vicci.process.model.sofiainstance.ComplexTypeInstance;
import eu.vicci.process.model.sofiainstance.DataTypeInstance;
import eu.vicci.process.model.sofiainstance.SofiaInstanceFactory;
import eu.vicci.process.model.util.serialization.jsontypeinstances.JSONTypeInstance;
import eu.vicci.process.model.util.serialization.jsontypeinstances.JSONTypeInstanceSerializer;
import eu.vicci.process.model.util.serialization.jsontypeinstances.core.IJSONComplexTypeInstance;
import eu.vicci.process.model.util.serialization.jsontypeinstances.core.IJSONTypeInstance;
import java.util.ArrayList;
import java.util.List;

public class JSONComplexTypeInstance
extends JSONTypeInstance
implements IJSONComplexTypeInstance {
    @JsonDeserialize(contentAs=JSONTypeInstance.class)
    private List<IJSONTypeInstance> subTypes = new ArrayList<IJSONTypeInstance>();

    public JSONComplexTypeInstance() {
    }

    public JSONComplexTypeInstance(ComplexTypeInstance complexType) {
        super((DataTypeInstance)complexType);
        this.addSubtypes(complexType);
    }

    public List<IJSONTypeInstance> getSubTypes() {
        return this.subTypes;
    }

    public void setSubTypes(List<IJSONTypeInstance> subTypes) {
        this.subTypes = subTypes;
    }

    public ComplexTypeInstance makeDataTypeInstance(SofiaInstanceFactory instanceFactory) {
        ComplexTypeInstance cti = instanceFactory.createComplexTypeInstance();
        for (IJSONTypeInstance subType : this.subTypes) {
            cti.getSubtypes().add((Object)subType.makeDataTypeInstance(instanceFactory));
        }
        this.addBaseInformationsToDataTypeInstance((DataTypeInstance)cti);
        this.addBelongsTo(cti);
        return cti;
    }

    public String toString() {
        String subTypeString = "";
        for (IJSONTypeInstance subType : this.subTypes) {
            subTypeString = String.valueOf(subTypeString) + subType.toString() + "\n";
        }
        return String.valueOf(this.getClass().getSimpleName()) + "[ Elements: {\n" + subTypeString + "}, InstanceID:" + this.getInstanceID() + "]";
    }

    @Override
    public String getValueStringComplete() {
        String result = "";
        for (IJSONTypeInstance item : this.subTypes) {
            result = String.valueOf(result) + item.getValueStringComplete() + ", ";
        }
        if (result.endsWith(", ")) {
            result = result.substring(0, result.length() - 2);
        }
        return result;
    }

    @Override
    public Object getValueAsObject() {
        return null;
    }

    private void addBelongsTo(ComplexTypeInstance parent) {
        for (DataTypeInstance child : parent.getSubtypes()) {
            child.setBelongsTo(parent);
        }
    }

    private void addSubtypes(ComplexTypeInstance complexType) {
        for (DataTypeInstance subtype : complexType.getSubtypes()) {
            this.subTypes.add(JSONTypeInstanceSerializer.makeJSONTypeInstance(subtype));
        }
    }

    public IJSONComplexTypeInstance makeCopy() {
        JSONComplexTypeInstance copy = new JSONComplexTypeInstance();
        this.copyBaseInformationsToJson(copy);
        this.copySubTypes(copy);
        return copy;
    }

    private void copySubTypes(IJSONComplexTypeInstance newInstance) {
        ArrayList<IJSONTypeInstance> newSubs = new ArrayList<IJSONTypeInstance>();
        for (IJSONTypeInstance sub : this.subTypes) {
            newSubs.add(sub.makeCopy());
        }
        newInstance.setSubTypes(newSubs);
    }

    public void parseValue(String value) throws IllegalArgumentException {
        throw new IllegalArgumentException("String cannot be parsed to complex type");
    }
}

