/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.util.serialization.jsontypeinstances;

import eu.vicci.process.model.sofiainstance.BooleanTypeInstance;
import eu.vicci.process.model.sofiainstance.DataTypeInstance;
import eu.vicci.process.model.sofiainstance.SofiaInstanceFactory;
import eu.vicci.process.model.util.serialization.jsontypeinstances.JSONTypeInstance;
import eu.vicci.process.model.util.serialization.jsontypeinstances.core.IJSONBooleanTypeInstance;

public class JSONBooleanTypeInstance
extends JSONTypeInstance
implements IJSONBooleanTypeInstance {
    private boolean value;

    public JSONBooleanTypeInstance() {
    }

    public JSONBooleanTypeInstance(BooleanTypeInstance booleanType) {
        super((DataTypeInstance)booleanType);
        this.value = booleanType.isValue();
    }

    public boolean getValue() {
        return this.value;
    }

    public void setValue(boolean value) {
        this.value = value;
    }

    @Override
    public Boolean getValueAsObject() {
        return this.value;
    }

    public BooleanTypeInstance makeDataTypeInstance(SofiaInstanceFactory instanceFactory) {
        BooleanTypeInstance bti = instanceFactory.createBooleanTypeInstance();
        bti.setValue(this.value);
        this.addBaseInformationsToDataTypeInstance((DataTypeInstance)bti);
        return bti;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[ Value: " + this.value + ", InstanceID:" + this.getInstanceID() + "]";
    }

    @Override
    public String getValueStringComplete() {
        return String.valueOf(this.getName()) + ": " + this.value;
    }

    @Override
    public String getValueString() {
        return String.valueOf(this.value);
    }

    public IJSONBooleanTypeInstance makeCopy() {
        JSONBooleanTypeInstance copy = new JSONBooleanTypeInstance();
        this.copyBaseInformationsToJson(copy);
        copy.setValue(this.value);
        return copy;
    }

    public void parseValue(String value) throws IllegalArgumentException {
        this.value = Boolean.parseBoolean(value);
    }
}

