/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.util.serialization.jsonprocesssteps;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import eu.vicci.process.model.sofia.FalseTransition;
import eu.vicci.process.model.sofia.SofiaFactory;
import eu.vicci.process.model.sofia.Transition;
import eu.vicci.process.model.sofia.TrueTransition;
import eu.vicci.process.model.util.serialization.jsonprocesssteps.JSONPort;
import eu.vicci.process.model.util.serialization.jsonprocesssteps.JSONProcessStepSerializer;
import eu.vicci.process.model.util.serialization.jsonprocesssteps.core.IJSONPort;
import eu.vicci.process.model.util.serialization.jsonprocesssteps.core.IJSONTransition;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="@class")
public class JSONTransition
implements IJSONTransition {
    private String id;
    private String type;
    @JsonDeserialize(as=JSONPort.class)
    private IJSONPort sourcePort;
    @JsonDeserialize(as=JSONPort.class)
    private IJSONPort targetPort;

    public JSONTransition() {
    }

    public JSONTransition(Transition transition) {
        this.id = transition.getId();
        JSONProcessStepSerializer.alreadySerialized.put(this.id, this);
        this.sourcePort = JSONProcessStepSerializer.alreadySerialized.containsKey(transition.getSourcePort().getId()) ? (IJSONPort)JSONProcessStepSerializer.alreadySerialized.get(transition.getSourcePort().getId()) : new JSONPort(transition.getSourcePort());
        this.targetPort = JSONProcessStepSerializer.alreadySerialized.containsKey(transition.getTargetPort().getId()) ? (IJSONPort)JSONProcessStepSerializer.alreadySerialized.get(transition.getTargetPort().getId()) : new JSONPort(transition.getTargetPort());
        this.type = transition.getClass().getCanonicalName();
    }

    public Transition makeTransition() {
        Object transition = null;
        if (JSONProcessStepSerializer.alreadyInstanciated.containsKey(this.id)) {
            return (Transition)JSONProcessStepSerializer.alreadyInstanciated.get(this.id);
        }
        if (this.type.equals(TrueTransition.class.getCanonicalName())) {
            transition = SofiaFactory.eINSTANCE.createTrueTransition();
        }
        transition = this.type.equals(FalseTransition.class.getCanonicalName()) ? SofiaFactory.eINSTANCE.createFalseTransition() : SofiaFactory.eINSTANCE.createTransition();
        transition.setId(this.id);
        transition.setSourcePort(this.sourcePort.makePort());
        transition.setTargetPort(this.targetPort.makePort());
        JSONProcessStepSerializer.alreadyInstanciated.put(this.id, transition);
        return transition;
    }
}

