/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.util.serialization.jsonprocesssteps;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import eu.vicci.process.model.sofia.Identifiable;
import eu.vicci.process.model.util.serialization.jsonprocesssteps.core.IJSONProcessStep;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@id")
@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="@class")
public class JSONProcessStep
implements IJSONProcessStep {
    @JsonDeserialize(contentAs=JSONProcessStep.class)
    public static Map<String, IJSONProcessStep> alreadyDone = new HashMap<String, IJSONProcessStep>();
    private Map<String, Object> fieldMap = new HashMap<String, Object>();

    public JSONProcessStep(Identifiable ident) {
        List<Field> fields = JSONProcessStep.getAllFields(new ArrayList<Field>(), ident.getClass());
        for (Field field : fields) {
            if (this.fieldMap.containsKey(field.getName())) continue;
            field.setAccessible(true);
            Object fieldValue = null;
            try {
                fieldValue = field.get(ident);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (fieldValue == null) continue;
            if (fieldValue instanceof Identifiable) {
                this.fieldMap.put(field.getName(), new JSONProcessStep((Identifiable)fieldValue));
                continue;
            }
            if (fieldValue instanceof EList) {
                EList elist = (EList)fieldValue;
                ArrayList<JSONProcessStep> list = new ArrayList<JSONProcessStep>();
                for (Object itemOb : elist) {
                    Identifiable item = (Identifiable)itemOb;
                    JSONProcessStep putin = alreadyDone.containsKey(item.getId()) ? alreadyDone.get(item.getId()) : new JSONProcessStep(item);
                    list.add(putin);
                }
                this.fieldMap.put(field.getName(), list);
                continue;
            }
            this.fieldMap.put(field.getName(), fieldValue);
        }
    }

    public static List<Field> getAllFields(List<Field> fields, Class<?> type) {
        fields.addAll(Arrays.asList(type.getDeclaredFields()));
        if (type.getSuperclass() != null) {
            fields = JSONProcessStep.getAllFields(fields, type.getSuperclass());
        }
        return fields;
    }
}

