/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.util.serialization.jsonprocesssteps;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import eu.vicci.process.model.sofia.EndControlPort;
import eu.vicci.process.model.sofia.EndDataPort;
import eu.vicci.process.model.sofia.EscalationPort;
import eu.vicci.process.model.sofia.Port;
import eu.vicci.process.model.sofia.SofiaFactory;
import eu.vicci.process.model.sofia.StartControlPort;
import eu.vicci.process.model.sofia.StartDataPort;
import eu.vicci.process.model.sofia.Transition;
import eu.vicci.process.model.util.serialization.jsonprocesssteps.JSONDataPort;
import eu.vicci.process.model.util.serialization.jsonprocesssteps.JSONEscalationPort;
import eu.vicci.process.model.util.serialization.jsonprocesssteps.JSONProcessStepSerializer;
import eu.vicci.process.model.util.serialization.jsonprocesssteps.JSONTransition;
import eu.vicci.process.model.util.serialization.jsonprocesssteps.core.IJSONPort;
import eu.vicci.process.model.util.serialization.jsonprocesssteps.core.IJSONTransition;
import eu.vicci.process.model.util.serialization.jsonprocesssteps.core.PortType;
import java.util.ArrayList;
import java.util.List;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="@class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=JSONDataPort.class, name="JSONDataPort"), @JsonSubTypes.Type(value=JSONEscalationPort.class, name="JSONEscalationPort")})
public class JSONPort
implements IJSONPort {
    private String type;
    private String id;
    private String description;
    private String name;
    private PortType portType;
    private boolean isOptional;
    @JsonDeserialize(as=JSONTransition.class)
    private IJSONTransition inTransition;
    @JsonDeserialize(contentAs=JSONTransition.class)
    private List<IJSONTransition> outTransitions = new ArrayList<IJSONTransition>();

    public JSONPort() {
    }

    public JSONPort(Port port) {
        this.type = port.getClass().getCanonicalName();
        this.portType = JSONPort.getPortType(port);
        this.id = port.getId();
        this.name = port.getName();
        this.description = port.getDescription();
        this.isOptional = port.isOptional();
        JSONProcessStepSerializer.alreadySerialized.put(this.id, this);
        this.processTransitions(port);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String Id2) {
        this.id = Id2;
    }

    public List<IJSONTransition> getOutTransitions() {
        return this.outTransitions;
    }

    public void setOutTransitions(List<IJSONTransition> outTransitions) {
        this.outTransitions = outTransitions;
    }

    public IJSONTransition getInTransitions() {
        return this.inTransition;
    }

    public void setInTransitions(IJSONTransition inTransitions) {
        this.inTransition = inTransitions;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PortType getPortType() {
        return this.portType;
    }

    public void setPortType(PortType portType) {
        this.portType = portType;
    }

    public Port makePort() {
        if (JSONProcessStepSerializer.alreadyInstanciated.containsKey(this.id)) {
            return (Port)JSONProcessStepSerializer.alreadyInstanciated.get(this.id);
        }
        StartControlPort port = null;
        switch (this.portType) {
            case StartControlPort: {
                port = SofiaFactory.eINSTANCE.createStartControlPort();
                break;
            }
            case EndControlPort: {
                port = SofiaFactory.eINSTANCE.createEndControlPort();
                break;
            }
            case StartDataPort: {
                port = SofiaFactory.eINSTANCE.createStartDataPort();
                break;
            }
            case EndDataPort: {
                port = SofiaFactory.eINSTANCE.createEndDataPort();
                break;
            }
            case EscalationPort: {
                port = SofiaFactory.eINSTANCE.createEscalationPort();
                break;
            }
            default: {
                throw new IllegalArgumentException("cant make port for type " + this.portType.name());
            }
        }
        this.addBaseInformationsToPort((Port)port);
        return port;
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public void setOptional(boolean isOptional) {
        this.isOptional = isOptional;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    protected void addBaseInformationsToPort(Port port) {
        port.setName(this.name);
        port.setId(this.id);
        port.setOptional(this.isOptional);
        port.setDescription(this.description);
        if (this.inTransition != null) {
            port.setInTransitions(this.inTransition.makeTransition());
        }
        for (IJSONTransition trans : this.outTransitions) {
            port.getOutTransitions().add((Object)trans.makeTransition());
        }
        JSONProcessStepSerializer.alreadyInstanciated.put(this.id, port);
    }

    private boolean isVisible(Transition inTransition) {
        Port[] ports;
        Port[] portArray = ports = new Port[]{inTransition.getSourcePort(), inTransition.getTargetPort()};
        int n = ports.length;
        int n2 = 0;
        while (n2 < n) {
            Port port = portArray[n2];
            String portParentId = port.getProcessStep().getId();
            if (!JSONProcessStepSerializer.alreadySerialized.containsKey(portParentId)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private void processTransitions(Port port) {
        Transition it = port.getInTransitions();
        if (it != null && this.isVisible(it)) {
            this.inTransition = JSONProcessStepSerializer.alreadySerialized.containsKey(it.getId()) ? (IJSONTransition)JSONProcessStepSerializer.alreadySerialized.get(it.getId()) : new JSONTransition(port.getInTransitions());
        }
        for (Transition transition : port.getOutTransitions()) {
            if (!this.isVisible(transition)) continue;
            if (JSONProcessStepSerializer.alreadySerialized.containsKey(transition.getId())) {
                this.outTransitions.add((JSONTransition)JSONProcessStepSerializer.alreadySerialized.get(transition.getId()));
                continue;
            }
            this.outTransitions.add(new JSONTransition(transition));
        }
    }

    private static PortType getPortType(Port port) {
        if (port instanceof StartDataPort) {
            return PortType.StartDataPort;
        }
        if (port instanceof EndDataPort) {
            return PortType.EndDataPort;
        }
        if (port instanceof StartControlPort) {
            return PortType.StartControlPort;
        }
        if (port instanceof EndControlPort) {
            return PortType.EndControlPort;
        }
        if (port instanceof EscalationPort) {
            return PortType.EscalationPort;
        }
        throw new IllegalArgumentException("cant serialize port of type" + port.getClass().getCanonicalName());
    }
}

