/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.util.serialization.jsonprocesssteps;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import eu.vicci.process.model.sofia.DataPort;
import eu.vicci.process.model.sofia.Port;
import eu.vicci.process.model.util.serialization.jsonprocesssteps.JSONPort;
import eu.vicci.process.model.util.serialization.jsonprocesssteps.core.IJSONDataPort;
import eu.vicci.process.model.util.serialization.jsontypes.JSONType;
import eu.vicci.process.model.util.serialization.jsontypes.JSONTypeSerializer;
import eu.vicci.process.model.util.serialization.jsontypes.core.IJSONType;

public class JSONDataPort
extends JSONPort
implements IJSONDataPort {
    @JsonDeserialize(as=JSONType.class)
    private IJSONType dataType;
    private String value;

    public JSONDataPort() {
    }

    public JSONDataPort(DataPort dataPort) {
        super((Port)dataPort);
        this.dataType = JSONTypeSerializer.makeJSONType(dataPort.getPortDatatype());
    }

    public DataPort makePort() {
        DataPort dataPort = (DataPort)super.makePort();
        dataPort.setPortDatatype(this.dataType.makeDataType());
        dataPort.setValue(this.value);
        return dataPort;
    }

    public IJSONType getDataType() {
        return this.dataType;
    }

    public void setDataType(IJSONType dataType) {
        this.dataType = dataType;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

