/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.util.serialization.jsonprocessstepinstances;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import eu.vicci.process.model.sofiainstance.FalseTransitionInstance;
import eu.vicci.process.model.sofiainstance.SofiaInstanceFactory;
import eu.vicci.process.model.sofiainstance.TransitionInstance;
import eu.vicci.process.model.sofiainstance.TrueTransitionInstance;
import eu.vicci.process.model.util.serialization.jsonprocessstepinstances.JSONPortInstance;
import eu.vicci.process.model.util.serialization.jsonprocessstepinstances.JSONProcessStepInstanceSerializer;
import eu.vicci.process.model.util.serialization.jsonprocessstepinstances.core.IJSONPortInstance;
import eu.vicci.process.model.util.serialization.jsonprocessstepinstances.core.IJSONTransitionInstance;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="@class")
public class JSONTransitionInstance
implements IJSONTransitionInstance {
    private String instanceId;
    private int instanceNumber;
    private String type;
    @JsonDeserialize(as=JSONPortInstance.class)
    private IJSONPortInstance sourcePortInstance;
    @JsonDeserialize(as=JSONPortInstance.class)
    private IJSONPortInstance targetPortInstance;

    public JSONTransitionInstance() {
    }

    public JSONTransitionInstance(TransitionInstance transition) {
        this.instanceId = transition.getInstanceId();
        this.type = transition.getClass().getCanonicalName();
        this.instanceNumber = transition.getInstancenumber();
        JSONProcessStepInstanceSerializer.alreadySerialized.put(this.instanceId, this);
        this.sourcePortInstance = JSONProcessStepInstanceSerializer.alreadySerialized.containsKey(transition.getSourcePortInstance().getInstanceId()) ? (IJSONPortInstance)JSONProcessStepInstanceSerializer.alreadySerialized.get(transition.getSourcePortInstance().getInstanceId()) : new JSONPortInstance(transition.getSourcePortInstance());
        this.targetPortInstance = JSONProcessStepInstanceSerializer.alreadySerialized.containsKey(transition.getTargetPortInstance().getInstanceId()) ? (IJSONPortInstance)JSONProcessStepInstanceSerializer.alreadySerialized.get(transition.getTargetPortInstance().getInstanceId()) : new JSONPortInstance(transition.getTargetPortInstance());
    }

    public TransitionInstance makeTransitionInstance(SofiaInstanceFactory factory) {
        Object transition = null;
        if (this.instanceId != null && JSONProcessStepInstanceSerializer.alreadyInstanciated.containsKey(this.instanceId)) {
            return (TransitionInstance)JSONProcessStepInstanceSerializer.alreadyInstanciated.get(this.instanceId);
        }
        if (TrueTransitionInstance.class.getCanonicalName().equals(this.type)) {
            transition = factory.createTrueTransitionInstance();
        }
        transition = FalseTransitionInstance.class.getCanonicalName().equals(this.type) ? factory.createFalseTransitionInstance() : factory.createTransitionInstance();
        transition.setInstanceId(this.instanceId);
        transition.setInstancenumber(this.instanceNumber);
        transition.setSourcePortInstance(this.sourcePortInstance.makePortInstance(factory));
        transition.setTargetPortInstance(this.targetPortInstance.makePortInstance(factory));
        JSONProcessStepInstanceSerializer.alreadyInstanciated.put(this.instanceId, transition);
        return transition;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public int getInstanceNumber() {
        return this.instanceNumber;
    }

    public void setInstanceNumber(int instanceNumber) {
        this.instanceNumber = instanceNumber;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public IJSONPortInstance getSourcePortInstance() {
        return this.sourcePortInstance;
    }

    public void setSourcePortInstance(IJSONPortInstance sourcePortInstance) {
        this.sourcePortInstance = sourcePortInstance;
    }

    public IJSONPortInstance getTargetPortInstance() {
        return this.targetPortInstance;
    }

    public void setTargetPortInstance(IJSONPortInstance targetPortInstance) {
        this.targetPortInstance = targetPortInstance;
    }
}

