/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.util.serialization.jsonprocessstepinstances;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import eu.vicci.process.model.sofiainstance.ExecutionPermission;
import eu.vicci.process.model.sofiainstance.PortInstance;
import eu.vicci.process.model.sofiainstance.ProcessStepInstance;
import eu.vicci.process.model.sofiainstance.SofiaInstanceFactory;
import eu.vicci.process.model.util.serialization.jsonprocessstepinstances.JSONEventInstance;
import eu.vicci.process.model.util.serialization.jsonprocessstepinstances.JSONIfInstance;
import eu.vicci.process.model.util.serialization.jsonprocessstepinstances.JSONPortInstance;
import eu.vicci.process.model.util.serialization.jsonprocessstepinstances.JSONProcessStepInstanceSerializer;
import eu.vicci.process.model.util.serialization.jsonprocessstepinstances.core.IJSONPortInstance;
import eu.vicci.process.model.util.serialization.jsonprocessstepinstances.core.IJSONProcessStepInstance;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@id")
@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="@class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=JSONEventInstance.class, name="JSONEventInstance"), @JsonSubTypes.Type(value=JSONIfInstance.class, name="JSONIfInstance")})
public class JSONProcessStepInstance
implements IJSONProcessStepInstance {
    private static final Logger LOG = LoggerFactory.getLogger(JSONProcessStepInstance.class);
    @JsonIgnore
    private static final String ERROR_MSG = "ERROR: Cant completely deserialize the JSONProcessStepInstance - FIXME\n";
    private long delay;
    private int executionState;
    private int instanceNumber;
    private int executionPermission;
    private String processInstanceId;
    private String processModelId;
    private String instanceId;
    private String modelId;
    private String type;
    private String simpleTypeName;
    @JsonDeserialize(contentAs=JSONProcessStepInstance.class)
    private List<IJSONProcessStepInstance> subSteps = new ArrayList<IJSONProcessStepInstance>();
    @JsonDeserialize(contentAs=JSONPortInstance.class)
    private List<IJSONPortInstance> ports = new ArrayList<IJSONPortInstance>();

    public JSONProcessStepInstance() {
    }

    public JSONProcessStepInstance(ProcessStepInstance stepInstance) {
        this.type = stepInstance.getClass().getCanonicalName();
        this.simpleTypeName = stepInstance.getClass().getSimpleName();
        this.delay = stepInstance.getDelay();
        this.executionState = stepInstance.getExecutionState().getValue();
        this.instanceId = stepInstance.getInstanceId();
        this.instanceNumber = stepInstance.getInstancenumber();
        this.executionPermission = stepInstance.getPermission().getValue();
        this.processInstanceId = stepInstance.getProcessInstanceID();
        this.processModelId = stepInstance.getProcessModelID();
        this.modelId = stepInstance.getProcessStepType().getId();
        JSONProcessStepInstanceSerializer.alreadySerialized.put(this.instanceId, this);
        for (ProcessStepInstance subStep : stepInstance.getSubSteps()) {
            if (JSONProcessStepInstanceSerializer.alreadySerialized.containsKey(subStep.getInstanceId())) {
                this.subSteps.add((JSONProcessStepInstance)JSONProcessStepInstanceSerializer.alreadySerialized.get(subStep.getInstanceId()));
                continue;
            }
            this.subSteps.add(new JSONProcessStepInstance(subStep));
        }
        for (PortInstance port : stepInstance.getPorts()) {
            if (JSONProcessStepInstanceSerializer.alreadySerialized.containsKey(port.getInstanceId())) {
                this.ports.add((IJSONPortInstance)JSONProcessStepInstanceSerializer.alreadySerialized.get(port.getInstanceId()));
                continue;
            }
            this.ports.add(JSONProcessStepInstanceSerializer.makeJSONPortInstance(port));
        }
    }

    public ProcessStepInstance makeProcessStepInstance(SofiaInstanceFactory factory) {
        ProcessStepInstance result = null;
        if (JSONProcessStepInstanceSerializer.alreadyInstanciated.containsKey(this.instanceId)) {
            return (ProcessStepInstance)JSONProcessStepInstanceSerializer.alreadyInstanciated.get(this.instanceId);
        }
        try {
            String tmpName = this.simpleTypeName;
            if (tmpName.contains("ImplCustom")) {
                tmpName = tmpName.replace("ImplCustom", "");
            } else if (tmpName.contains("Impl")) {
                tmpName.replace("Impl", "");
            }
            String methodName = "create" + tmpName;
            Method method = factory.getClass().getMethod(methodName, new Class[0]);
            result = (ProcessStepInstance)method.invoke((Object)factory, new Object[0]);
            JSONProcessStepInstanceSerializer.alreadyInstanciated.put(this.instanceId, result);
            result.setDelay(this.delay);
            result.setPermission(ExecutionPermission.get((int)this.executionPermission));
            result.setInstanceId(this.instanceId);
            result.setInstancenumber(this.instanceNumber);
            result.setProcessInstanceID(this.processInstanceId);
            result.setProcessModelID(this.processModelId);
            for (IJSONPortInstance jsonPort : this.ports) {
                result.getPorts().add((Object)jsonPort.makePortInstance(factory));
            }
            for (IJSONProcessStepInstance subStep : this.subSteps) {
                ProcessStepInstance tmp = subStep.makeProcessStepInstance(factory);
                if (tmp == null) continue;
                result.getSubSteps().add((Object)tmp);
            }
        }
        catch (NoSuchMethodException e) {
            LOG.error("Cant find method on SofiaFactory: {}", (Object)e.getMessage());
            LOG.error(ERROR_MSG);
        }
        catch (Exception e) {
            LOG.error(ERROR_MSG);
            e.printStackTrace();
        }
        return result;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public int getState() {
        return this.executionState;
    }

    public void setState(int state) {
        this.executionState = state;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public int getInstanceNumber() {
        return this.instanceNumber;
    }

    public void setInstanceNumber(int instanceNumber) {
        this.instanceNumber = instanceNumber;
    }

    public int getPermission() {
        return this.executionPermission;
    }

    public void setPermission(int permission) {
        this.executionPermission = permission;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getProcessModelId() {
        return this.processModelId;
    }

    public void setProcessModelId(String processModelId) {
        this.processModelId = processModelId;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<IJSONProcessStepInstance> getSubSteps() {
        return this.subSteps;
    }

    public void setSubSteps(List<IJSONProcessStepInstance> subSteps) {
        this.subSteps = subSteps;
    }

    public String getModelId() {
        return this.modelId;
    }

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public String getSimpleTypeName() {
        return this.simpleTypeName;
    }

    public void setSimpleTypeName(String simpleTypeName) {
        this.simpleTypeName = simpleTypeName;
    }

    public List<IJSONPortInstance> getPorts() {
        return this.ports;
    }

    public void setPorts(List<IJSONPortInstance> ports) {
        this.ports = ports;
    }
}

