/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.util.serialization.jsonprocessstepinstances;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import eu.vicci.process.model.sofiainstance.EndControlPortInstance;
import eu.vicci.process.model.sofiainstance.EndDataPortInstance;
import eu.vicci.process.model.sofiainstance.EscalationPortInstance;
import eu.vicci.process.model.sofiainstance.PortInstance;
import eu.vicci.process.model.sofiainstance.SofiaInstanceFactory;
import eu.vicci.process.model.sofiainstance.StartControlPortInstance;
import eu.vicci.process.model.sofiainstance.StartDataPortInstance;
import eu.vicci.process.model.sofiainstance.State;
import eu.vicci.process.model.sofiainstance.TransitionInstance;
import eu.vicci.process.model.util.serialization.jsonprocessstepinstances.JSONDataPortInstance;
import eu.vicci.process.model.util.serialization.jsonprocessstepinstances.JSONEscalationPortInstance;
import eu.vicci.process.model.util.serialization.jsonprocessstepinstances.JSONProcessStepInstanceSerializer;
import eu.vicci.process.model.util.serialization.jsonprocessstepinstances.JSONTransitionInstance;
import eu.vicci.process.model.util.serialization.jsonprocessstepinstances.core.IJSONPortInstance;
import eu.vicci.process.model.util.serialization.jsonprocessstepinstances.core.IJSONTransitionInstance;
import eu.vicci.process.model.util.serialization.jsonprocessstepinstances.core.PortInstanceType;
import eu.vicci.process.model.util.serialization.jsonprocesssteps.JSONPort;
import eu.vicci.process.model.util.serialization.jsonprocesssteps.JSONProcessStepSerializer;
import eu.vicci.process.model.util.serialization.jsonprocesssteps.core.IJSONPort;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="@class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=JSONDataPortInstance.class, name="JSONDataPortInstance"), @JsonSubTypes.Type(value=JSONEscalationPortInstance.class, name="JSONEscalationPortInstance")})
public class JSONPortInstance
implements IJSONPortInstance {
    private static final Logger LOG = LoggerFactory.getLogger(JSONPortInstance.class);
    private String type;
    private State executionState;
    private String instanceId;
    private int instanceNumber;
    private String name;
    private String typeId;
    private PortInstanceType portInstanceType;
    private boolean doDeactivation = false;
    @JsonDeserialize(as=JSONPort.class)
    private IJSONPort portType;
    @JsonDeserialize(contentAs=JSONTransitionInstance.class)
    private List<IJSONTransitionInstance> outTransitions = new ArrayList<IJSONTransitionInstance>();
    @JsonDeserialize(as=JSONTransitionInstance.class)
    private IJSONTransitionInstance inTransitions;

    public JSONPortInstance() {
    }

    public JSONPortInstance(PortInstance portInstance) {
        this.type = portInstance.getClass().getCanonicalName();
        this.portInstanceType = JSONPortInstance.getPortInstanceType(portInstance);
        this.executionState = portInstance.getExecutionState();
        this.instanceId = portInstance.getInstanceId();
        this.instanceNumber = portInstance.getInstancenumber();
        this.name = portInstance.getName();
        this.typeId = portInstance.getTypeId();
        JSONProcessStepInstanceSerializer.alreadySerialized.put(this.instanceId, this);
        this.portType = JSONProcessStepSerializer.makeJSONPort(portInstance.getPortType());
    }

    private void processTransitions(PortInstance portInstance) {
        TransitionInstance inTransition = portInstance.getInTransitionInstances();
        if (inTransition != null && this.isVisible(inTransition)) {
            this.inTransitions = JSONProcessStepInstanceSerializer.alreadySerialized.containsKey(inTransition.getInstanceId()) ? (IJSONTransitionInstance)JSONProcessStepInstanceSerializer.alreadySerialized.get(inTransition.getInstanceId()) : new JSONTransitionInstance(portInstance.getInTransitionInstances());
        }
        for (TransitionInstance transition : portInstance.getOutTransitionInstances()) {
            if (!this.isVisible(transition)) {
                return;
            }
            if (JSONProcessStepInstanceSerializer.alreadySerialized.containsKey(transition.getInstanceId())) {
                this.outTransitions.add((JSONTransitionInstance)JSONProcessStepInstanceSerializer.alreadySerialized.get(transition.getInstanceId()));
                continue;
            }
            this.outTransitions.add(new JSONTransitionInstance(transition));
        }
    }

    private boolean isVisible(TransitionInstance inTransition) {
        PortInstance[] ports;
        PortInstance[] portInstanceArray = ports = new PortInstance[]{inTransition.getSourcePortInstance(), inTransition.getTargetPortInstance()};
        int n = ports.length;
        int n2 = 0;
        while (n2 < n) {
            PortInstance port = portInstanceArray[n2];
            String portParentId = port.getProcessStepInstance().getInstanceId();
            if (!JSONProcessStepInstanceSerializer.alreadySerialized.containsKey(portParentId)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public State getExecutionState() {
        return this.executionState;
    }

    public void setExecutionState(State executionState) {
        this.executionState = executionState;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public int getInstanceNumber() {
        return this.instanceNumber;
    }

    public void setInstanceNumber(int instanceNumber) {
        this.instanceNumber = instanceNumber;
    }

    public List<IJSONTransitionInstance> getOutTransitions() {
        return this.outTransitions;
    }

    public void setOutTransitions(List<IJSONTransitionInstance> outTransitions) {
        this.outTransitions = outTransitions;
    }

    public IJSONTransitionInstance getInTransitions() {
        return this.inTransitions;
    }

    public void setInTransitions(IJSONTransitionInstance inTransitions) {
        this.inTransitions = inTransitions;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTypeId() {
        return this.typeId;
    }

    public void setTypeId(String typeId) {
        this.typeId = typeId;
    }

    public PortInstance makePortInstance(SofiaInstanceFactory factory) {
        if (JSONProcessStepInstanceSerializer.alreadyInstanciated.containsKey(this.instanceId)) {
            return (PortInstance)JSONProcessStepInstanceSerializer.alreadyInstanciated.get(this.instanceId);
        }
        StartControlPortInstance portInstance = null;
        switch (this.portInstanceType) {
            case StartControlPortInstance: {
                portInstance = factory.createStartControlPortInstance();
                break;
            }
            case StartDataPortInstance: {
                portInstance = factory.createStartDataPortInstance();
                break;
            }
            case EndControlPortInstance: {
                portInstance = factory.createEndControlPortInstance();
                break;
            }
            case EndDataPortInstance: {
                portInstance = factory.createEndDataPortInstance();
                break;
            }
            case EscalationPortInstance: {
                portInstance = factory.createEscalationPortInstance();
                break;
            }
            default: {
                throw new IllegalArgumentException("cant make portinstance for type " + this.portInstanceType.name());
            }
        }
        this.addBaseInformationsToPortInstance((PortInstance)portInstance, factory);
        JSONProcessStepInstanceSerializer.alreadyInstanciated.put(this.instanceId, portInstance);
        return portInstance;
    }

    protected void addBaseInformationsToPortInstance(PortInstance portInstance, SofiaInstanceFactory factory) {
        try {
            portInstance.setExecutionState(this.executionState);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            LOG.error("ERROR: Cant set Execution State to Port on default Factory - FIXME");
        }
        portInstance.setInstanceId(this.instanceId);
        portInstance.setInstancenumber(this.instanceNumber);
        if (this.inTransitions != null) {
            portInstance.setInTransitionInstances(this.inTransitions.makeTransitionInstance(factory));
        }
        portInstance.setName(this.name);
        portInstance.setTypeId(this.typeId);
        portInstance.setPortType(this.portType.makePort());
    }

    public PortInstanceType getPortInstanceType() {
        return this.portInstanceType;
    }

    public void setPortInstanceType(PortInstanceType portInstanceType) {
        this.portInstanceType = portInstanceType;
    }

    private static PortInstanceType getPortInstanceType(PortInstance port) {
        if (port instanceof StartDataPortInstance) {
            return PortInstanceType.StartDataPortInstance;
        }
        if (port instanceof EndDataPortInstance) {
            return PortInstanceType.EndDataPortInstance;
        }
        if (port instanceof StartControlPortInstance) {
            return PortInstanceType.StartControlPortInstance;
        }
        if (port instanceof EndControlPortInstance) {
            return PortInstanceType.EndControlPortInstance;
        }
        if (port instanceof EscalationPortInstance) {
            return PortInstanceType.EscalationPortInstance;
        }
        throw new IllegalArgumentException("cant serialize portinstance of type" + port.getClass().getCanonicalName());
    }

    public IJSONPort getPortType() {
        return this.portType;
    }

    public void setPortType(IJSONPort portType) {
        this.portType = portType;
    }

    public boolean getDoDeactivation() {
        return this.doDeactivation;
    }

    public void setDoDeactivation(boolean doDeactivation) {
        this.doDeactivation = doDeactivation;
    }
}

