/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.util.serialization;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.vicci.process.model.sofia.DataType;
import eu.vicci.process.model.sofia.Identifiable;
import eu.vicci.process.model.sofia.Port;
import eu.vicci.process.model.sofia.ProcessStep;
import eu.vicci.process.model.util.serialization.jsonprocesssteps.JSONPort;
import eu.vicci.process.model.util.serialization.jsonprocesssteps.JSONProcessStep;
import eu.vicci.process.model.util.serialization.jsontypes.JSONTypeSerializer;
import java.util.HashMap;
import java.util.Map;

public class JSONSerializer {
    public static Map<String, Object> processed = new HashMap<String, Object>();

    public static synchronized String serialize(Object input) {
        processed.clear();
        Object object = input;
        if (input instanceof Port) {
            object = new JSONPort((Port)input);
        }
        if (input instanceof ProcessStep) {
            object = new JSONProcessStep((Identifiable)input);
        }
        if (input instanceof DataType) {
            return JSONTypeSerializer.serialize((DataType)input);
        }
        String output = "";
        ObjectMapper mapper = new ObjectMapper();
        try {
            output = mapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return output;
    }

    public static synchronized Object deserialize(String json) {
        ObjectMapper mapper = new ObjectMapper();
        Object result = null;
        try {
            result = mapper.readValue(json, Object.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static synchronized boolean addToProcessed(String id, Object obj) {
        if (processed.containsKey(id)) {
            return false;
        }
        processed.put(id, obj);
        return true;
    }

    public static boolean hasProcessed(String id) {
        return processed.containsKey(id);
    }

    public static Object getProcessed(String id) {
        return processed.get(id);
    }
}

