/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.util.messages;

import eu.vicci.process.model.util.messages.core.HumanTaskRequestListener;
import eu.vicci.process.model.util.messages.core.IHumanTaskRequest;
import eu.vicci.process.model.util.messages.core.IStateChangeMessage;
import eu.vicci.process.model.util.messages.core.IWampMessage;
import eu.vicci.process.model.util.messages.core.StateChangeListener;
import java.util.ArrayList;
import java.util.List;

public final class MessageQueue
implements Runnable {
    private static final String THREAD_NAME = "WampMessageQueue";
    private List<StateChangeListener> stateChangeListeners = new ArrayList<StateChangeListener>();
    private List<HumanTaskRequestListener> humanTaskRequestListeners = new ArrayList<HumanTaskRequestListener>();
    private List<IWampMessage> messages = new ArrayList<IWampMessage>();
    private boolean canceled = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addMessage(IWampMessage message) {
        Object object = this.messages;
        synchronized (object) {
            this.messages.add(message);
        }
        object = this;
        synchronized (object) {
            this.notifyAll();
        }
    }

    @Override
    public void run() {
        while (!this.canceled) {
            this.runTillTerminated();
        }
    }

    public void schedule() {
        Thread thread = new Thread(this);
        thread.setName(THREAD_NAME);
        thread.setDaemon(true);
        thread.start();
    }

    public void cancel() {
        this.canceled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStateChangeListener(StateChangeListener stateChangeListener) {
        List<StateChangeListener> list = this.stateChangeListeners;
        synchronized (list) {
            this.stateChangeListeners.add(stateChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStateChangeListener(StateChangeListener stateChangeListener) {
        List<StateChangeListener> list = this.stateChangeListeners;
        synchronized (list) {
            this.stateChangeListeners.remove(stateChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHumanTaskRequestListener(HumanTaskRequestListener humanTaskRequestListener) {
        List<HumanTaskRequestListener> list = this.humanTaskRequestListeners;
        synchronized (list) {
            this.humanTaskRequestListeners.add(humanTaskRequestListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHumanTaskRequestListener(HumanTaskRequestListener humanTaskRequestListener) {
        List<HumanTaskRequestListener> list = this.humanTaskRequestListeners;
        synchronized (list) {
            this.humanTaskRequestListeners.remove(humanTaskRequestListener);
        }
    }

    private void handleMessage(IWampMessage message) {
        block3: {
            block2: {
                if (!(message instanceof IStateChangeMessage)) break block2;
                for (StateChangeListener stateChangeListener : this.stateChangeListeners) {
                    stateChangeListener.onMessage((IWampMessage)((IStateChangeMessage)message));
                }
                break block3;
            }
            if (!(message instanceof IHumanTaskRequest)) break block3;
            for (HumanTaskRequestListener humanTaskRequestListener : this.humanTaskRequestListeners) {
                humanTaskRequestListener.onMessage((IWampMessage)((IHumanTaskRequest)message));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForEvents() {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IWampMessage removeFirstMessage() {
        IWampMessage event = null;
        List<IWampMessage> list = this.messages;
        synchronized (list) {
            if (!this.messages.isEmpty()) {
                event = this.messages.remove(0);
            }
        }
        return event;
    }

    private void runTillTerminated() {
        if (this.messages.isEmpty()) {
            this.waitForEvents();
        }
        if (!this.canceled) {
            IWampMessage message = this.removeFirstMessage();
            if (message != null) {
                this.handleMessage(message);
            }
        } else {
            this.notifyAll();
        }
    }
}

