/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.util.messages;

import eu.vicci.process.model.util.messages.HumanTaskMessageManagerListener;
import eu.vicci.process.model.util.messages.core.IHumanTaskRequest;
import eu.vicci.process.model.util.messages.core.IHumanTaskResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HumanTaskMessageManager {
    private static final Logger logger = LoggerFactory.getLogger(HumanTaskMessageManager.class);
    private static HumanTaskMessageManager htmm = null;
    private Map<String, IHumanTaskRequest> openRequests = Collections.synchronizedMap(new HashMap());
    private Map<String, IHumanTaskResponse> openResponses = Collections.synchronizedMap(new HashMap());
    private Map<String, IHumanTaskRequest> closedRequests = Collections.synchronizedMap(new HashMap());
    private Map<String, IHumanTaskResponse> closedResponses = Collections.synchronizedMap(new HashMap());
    private List<HumanTaskMessageManagerListener> listeners = new CopyOnWriteArrayList<HumanTaskMessageManagerListener>(new ArrayList());

    private HumanTaskMessageManager() {
    }

    public static synchronized HumanTaskMessageManager getInstance() {
        if (htmm == null) {
            htmm = new HumanTaskMessageManager();
        }
        return htmm;
    }

    public synchronized void addHumanTaskResponse(IHumanTaskResponse response) {
        if (response.cancelReservation()) {
            this.cancelReservation(response);
        } else {
            this.addResponseIfNotPresent(response);
            if (!response.isSentForReservation()) {
                this.informAboutHumanTaskResponseAdded(response);
            }
        }
    }

    public synchronized void humanTaskResponseHandled(IHumanTaskResponse response) {
        String htInstanceId = response.getHumanTaskInstanceId();
        this.handleRequest(htInstanceId);
        this.handleResponse(htInstanceId);
    }

    public void addHumanTaskMessageManagerListener(HumanTaskMessageManagerListener listener) {
        this.listeners.add(listener);
    }

    public void removeHumanTaskMessageManagerListener(HumanTaskMessageManagerListener listener) {
        this.listeners.remove(listener);
    }

    public Map<String, IHumanTaskRequest> getOpenRequest() {
        return this.openRequests;
    }

    public Map<String, IHumanTaskResponse> getHandledResponses() {
        return this.closedResponses;
    }

    private boolean addResponseIfNotPresent(IHumanTaskResponse response) {
        String htInstanceId = response.getHumanTaskInstanceId();
        if (this.closedRequests.containsKey(htInstanceId)) {
            logger.warn("the human task with id '{}' was already handled", (Object)htInstanceId);
            return false;
        }
        this.openResponses.put(htInstanceId, response);
        return true;
    }

    private void cancelReservation(IHumanTaskResponse response) {
        String htInstanceId = response.getHumanTaskInstanceId();
        IHumanTaskResponse old = this.openResponses.remove(htInstanceId);
        if (old == null) {
            logger.warn("there was no open response for human task '{}'", (Object)htInstanceId);
        }
        if (!this.openRequests.containsKey(htInstanceId)) {
            logger.warn("there is no open request for human task '{}'", (Object)htInstanceId);
        } else {
            this.informAboutCancelation(response, this.openRequests.get(htInstanceId));
        }
    }

    private void handleResponse(String humanTaskInstanceId) {
        IHumanTaskResponse openResponse = this.openResponses.remove(humanTaskInstanceId);
        if (this.openResponses != null && !this.closedResponses.containsKey(humanTaskInstanceId)) {
            this.closedResponses.put(humanTaskInstanceId, openResponse);
        } else {
            logger.error("it seems that the human task response is already handled. Instance Id: {}", (Object)humanTaskInstanceId);
        }
    }

    private void handleRequest(String humanTaskInstanceId) {
        IHumanTaskRequest openRequest = this.openRequests.remove(humanTaskInstanceId);
        if (openRequest != null && !this.closedRequests.containsKey(humanTaskInstanceId)) {
            this.closedRequests.put(humanTaskInstanceId, openRequest);
        } else {
            logger.error("it seems that the human task request is already handled. Instance Id: {}", (Object)humanTaskInstanceId);
        }
    }

    private void informAboutCancelation(IHumanTaskResponse oldResponse, IHumanTaskRequest request) {
        for (HumanTaskMessageManagerListener listener : this.listeners) {
            listener.onHumanTaskResponseCanceled(oldResponse, request);
        }
    }

    private void informAboutHumanTaskResponseAdded(IHumanTaskResponse response) {
        for (HumanTaskMessageManagerListener listener : this.listeners) {
            listener.onHumanTaskResponseAdded(response);
        }
    }
}

