/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.util.logging;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import eu.vicci.process.model.sofiainstance.ProcessInstance;
import eu.vicci.process.model.sofiainstance.State;
import eu.vicci.process.model.util.configuration.ConfigurationManager;
import eu.vicci.process.model.util.logging.ElasticsearchClient;
import eu.vicci.process.model.util.logging.InstanceLogger;
import eu.vicci.process.model.util.logging.TimerWithStart;
import eu.vicci.process.model.util.messages.core.IStateChangeMessage;
import feign.Feign;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingManager {
    private static final Logger log = LoggerFactory.getLogger(LoggingManager.class);
    private static LoggingManager lm;
    private Map<String, InstanceLogger> loggers = new ConcurrentHashMap<String, InstanceLogger>();
    private List<IStateChangeMessage> recentStateChanges = new CopyOnWriteArrayList<IStateChangeMessage>();
    private Map<String, TimerWithStart> timerContexts = new ConcurrentHashMap<String, TimerWithStart>();
    private ElasticsearchClient esClient;
    private ObjectMapper objectMapper;

    public static synchronized LoggingManager getInstance() {
        if (lm == null) {
            lm = new LoggingManager();
        }
        return lm;
    }

    private LoggingManager() {
        String esHost = ConfigurationManager.getInstance().getConfigAsString("ELASTICSEARCH_HOST");
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        dateformat.setTimeZone(Calendar.getInstance().getTimeZone());
        this.objectMapper = new ObjectMapper();
        this.objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        this.objectMapper.setDateFormat((DateFormat)dateformat);
        if (esHost != null) {
            this.esClient = (ElasticsearchClient)Feign.builder().target(ElasticsearchClient.class, "http://" + esHost);
        }
    }

    public Map<String, InstanceLogger> getLoggers() {
        return this.loggers;
    }

    public void setLoggers(Map<String, InstanceLogger> loggers) {
        this.loggers = loggers;
    }

    public List<IStateChangeMessage> getRecentStateChanges() {
        return this.recentStateChanges;
    }

    public void createLoggingForInstance(ProcessInstance processInstance) {
        InstanceLogger il = new InstanceLogger(processInstance, new CopyOnWriteArrayList<IStateChangeMessage>());
        this.loggers.put(processInstance.getInstanceId(), il);
    }

    public void logStateMessage(IStateChangeMessage message) {
        this.report(message);
        this.loggers.get(message.getProcessInstanceId()).logStateMessage(message);
        this.recentStateChanges.add(message);
    }

    private void report(IStateChangeMessage message) {
        if (this.esClient == null) {
            return;
        }
        if (State.EXECUTING == message.getState()) {
            this.logExecutingIfNeeded(message);
        } else if (this.isFinishedState(message)) {
            this.logExecuted(message);
        }
    }

    private void logExecuted(IStateChangeMessage message) {
        LogIdentifier logId = new LogIdentifier(message);
        TimerWithStart timer = this.timerContexts.remove(logId.stepInstance).stop();
        Calendar cal = LoggingManager.getCurrentCalendar();
        int iMonth = cal.get(2) + 1;
        int iYear = cal.get(1);
        String month = iMonth < 10 ? "0" + String.valueOf(iMonth) : String.valueOf(iMonth);
        String year = String.valueOf(iYear);
        try {
            this.esClient.post(year, month, this.objectMapper.writeValueAsString((Object)timer));
        }
        catch (Exception e) {
            log.error("failed to send the logging to elasticsearch: '{}'", (Object)e.getMessage());
        }
    }

    private void logExecutingIfNeeded(IStateChangeMessage message) {
        LogIdentifier logId = new LogIdentifier(message);
        if (this.timerContexts.containsKey(logId.stepInstance)) {
            return;
        }
        TimerWithStart timer = TimerWithStart.create();
        timer.model = message.getProcessId();
        timer.step = message.getModelId();
        timer.stepInstance = message.getInstanceId();
        timer.name = "proteus." + timer.stepInstance;
        timer.process = message.getProcessName();
        timer.peer = message.getPeerId() == null ? "" : message.getPeerId();
        this.timerContexts.put(logId.stepInstance, timer);
    }

    private static Calendar getCurrentCalendar() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        return cal;
    }

    private boolean isFinishedState(IStateChangeMessage message) {
        switch (message.getState()) {
            case EXECUTED: 
            case FAILED: 
            case ESCALATED: {
                return true;
            }
        }
        return false;
    }

    private class LogIdentifier {
        private final String model;
        private final String step;
        private final String stepInstance;
        private final String peerId;

        public LogIdentifier(IStateChangeMessage message) {
            this.model = "model-" + message.getProcessId();
            this.step = String.valueOf(this.model) + ".step-" + message.getModelId();
            this.peerId = message.getPeerId() == null || message.getPeerId().equals("") ? "" : String.valueOf(message.getPeerId()) + "_";
            this.stepInstance = String.valueOf(this.step) + ".step-instance-" + this.peerId + message.getInstanceId();
        }
    }
}

