/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.util.configuration;

import eu.vicci.process.client.core.IClientManager;
import eu.vicci.process.client.core.IConfigurationReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigurationManager {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationManager.class);
    private static final String msgWrongType = "configuration value under the key '%s' was found but is from wrong type.\n expected: '%s'\n current: '%s'";
    private Map<String, Object> configurations = Collections.synchronizedMap(new HashMap());
    private IClientManager clientManager;

    private ConfigurationManager() {
    }

    public static ConfigurationManager getInstance() {
        return ConfigurationManagerLoader.INSTANCE;
    }

    public Object getConfiguration(String key) {
        return this.configurations.get(key);
    }

    public void setClientManager(IClientManager clientManager) {
        this.clientManager = clientManager;
    }

    public IClientManager getClientManager() {
        return this.clientManager;
    }

    public boolean hasClientManager() {
        return this.clientManager != null;
    }

    public <T> T getConfiguration(String key, Class<T> clazz) {
        Object value = this.configurations.get(key);
        if (value == null) {
            return null;
        }
        if (value.getClass().equals(clazz)) {
            return (T)value;
        }
        String msg = String.format(msgWrongType, key, clazz.getSimpleName(), value.getClass().getSimpleName());
        logger.error(msg);
        return null;
    }

    public String getConfigAsString(String key) {
        return this.getConfiguration(key, String.class);
    }

    public void updateFromConfigReader(IConfigurationReader reader) {
        this.addIfNotNull("OPENHAB_URI", reader.getOpenHabUri());
        this.addIfNotNull("FEEDBACK_SERVICE_URI", reader.getFeedbackServiceUri());
        this.addIfNotNull("ELASTICSEARCH_HOST", reader.getElasticsearchHost());
        this.addIfNotNull("FEEDBACK_CONTEXT_URI", reader.getContextUri());
        this.addIfNotNull("PROTEUS_WAMP_NAMESPACE", reader.getNamespace());
        this.addIfNotNull("PROTEUS_WAMP_REALM_NAME", reader.getRealmName());
        this.addIfNotNull("PROTEUS_WAMP_PORT", reader.getPort());
        this.addIfNotNull("PROTEUS_SUPER_PEER_IP", reader.getSuperPeerIp());
        this.addIfNotNull("PROTEUS_IP_FILTER", reader.getIpFilter());
        this.configurations.put("PROTEUS_HTTP_PORT", reader.getHttpPort());
    }

    private void addIfNotNull(String key, String value) {
        if (value == null) {
            return;
        }
        this.configurations.put(key, value);
    }

    /* synthetic */ ConfigurationManager(ConfigurationManager configurationManager) {
        this();
    }

    private static class ConfigurationManagerLoader {
        static ConfigurationManager INSTANCE = new ConfigurationManager(null);

        private ConfigurationManagerLoader() {
        }
    }
}

