/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.util;

import eu.vicci.process.client.core.IConfigurationReader;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationReader
implements IConfigurationReader {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationReader.class);
    private static final String TRUE_STR = "true";
    private static final String LIST_SEPARATOR = ",";
    private static final String ERR_PARSE_HTTP_PORT = "cant parse the given value to integer for {}. Please check your config.";
    private String ip;
    private String port;
    private String path;
    private String realmName;
    private String namespace;
    private String openHabUri;
    private int httpPort = 0;
    private String superPeerIp;
    private String contextUri;
    private String feedbackServiceUri;
    private boolean startOsgiRuntime;
    private boolean startOpenHabListener;
    private boolean startCepEngine;
    private boolean deployExistingProcessModels;
    private String elasticsearchHost;
    private String ipFilter;
    private List<String> devices;

    public ConfigurationReader() {
        this.readProperties();
    }

    public ConfigurationReader(String path) {
        this.path = path;
        this.readProperties();
    }

    public String getIp() {
        return this.ip;
    }

    public String getPort() {
        return this.port;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public int getPortAsInt() {
        return Integer.parseInt(this.port);
    }

    public String getRealmName() {
        return this.realmName;
    }

    public boolean startOsgiRuntime() {
        return this.startOsgiRuntime;
    }

    public boolean startOpenHabListener() {
        return this.startOpenHabListener;
    }

    public boolean startCepEngine() {
        return this.startCepEngine;
    }

    public boolean deployExistingProcessModels() {
        return this.deployExistingProcessModels;
    }

    public String getIpFilter() {
        return this.ipFilter;
    }

    private void readPropertiesFromFile() {
        Properties properties = new Properties();
        BufferedInputStream stream = null;
        try {
            stream = new BufferedInputStream(new FileInputStream(this.path));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return;
        }
        try {
            properties.load(stream);
            stream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        this.setProps(properties);
    }

    private void readPropertiesFromEnvironment() {
        this.ip = System.getenv("PROTEUS_SUPER_PEER_IP");
        this.port = System.getenv("PROTEUS_WAMP_PORT");
        this.realmName = System.getenv("PROTEUS_WAMP_REALM_NAME");
        this.namespace = System.getenv("PROTEUS_WAMP_NAMESPACE");
        String tmpDeploy = System.getenv("DEPLOY_EXISTING_PROCESSMODELS");
        this.deployExistingProcessModels = TRUE_STR.equals(tmpDeploy) || tmpDeploy == null && TRUE_STR.equals("false");
        this.openHabUri = System.getenv("OPENHAB_URI");
        this.startOpenHabListener = this.openHabUri != null;
        String tmpCep = System.getenv("START_CEP_ENGINE");
        this.startCepEngine = tmpCep == null || TRUE_STR.equals(tmpCep);
        this.elasticsearchHost = System.getenv("ELASTICSEARCH_HOST");
        this.superPeerIp = System.getenv("PROTEUS_SUPER_PEER_IP");
        this.ipFilter = System.getenv("PROTEUS_IP_FILTER");
        this.devices = this.splitValue(System.getenv("PROTEUS_DEVICES"), LIST_SEPARATOR);
        String tmpOsgi = System.getenv("START_OSGI_RUNTIME");
        this.startOsgiRuntime = TRUE_STR.equals(tmpOsgi) || tmpOsgi == null && TRUE_STR.equals("false");
        String tmpHttpPort = System.getenv("PROTEUS_HTTP_PORT");
        tmpHttpPort = tmpHttpPort == null ? "8082" : tmpHttpPort;
        try {
            this.httpPort = Integer.parseInt(tmpHttpPort);
        }
        catch (NumberFormatException numberFormatException) {
            LOG.error(ERR_PARSE_HTTP_PORT, (Object)"PROTEUS_HTTP_PORT");
        }
    }

    private void readProperties() {
        if (this.path == null) {
            this.readPropertiesFromEnvironment();
        } else {
            this.readPropertiesFromFile();
        }
        this.setDefaultValues();
    }

    private void setProps(Properties properties) {
        this.ip = properties.getProperty("PROTEUS_SUPER_PEER_IP");
        this.port = properties.getProperty("PROTEUS_WAMP_PORT");
        this.realmName = properties.getProperty("PROTEUS_WAMP_REALM_NAME");
        this.namespace = properties.getProperty("PROTEUS_WAMP_NAMESPACE");
        String tmpDeploy = properties.getProperty("DEPLOY_EXISTING_PROCESSMODELS");
        this.deployExistingProcessModels = TRUE_STR.equals(tmpDeploy) || tmpDeploy == null && TRUE_STR.equals("false");
        this.openHabUri = properties.getProperty("OPENHAB_URI");
        this.startOpenHabListener = this.openHabUri != null;
        String tmpCep = properties.getProperty("START_CEP_ENGINE");
        this.startCepEngine = tmpCep == null || TRUE_STR.equals(tmpCep);
        this.elasticsearchHost = properties.getProperty("ELASTICSEARCH_HOST");
        this.superPeerIp = properties.getProperty("PROTEUS_SUPER_PEER_IP");
        this.ipFilter = properties.getProperty("PROTEUS_IP_FILTER");
        this.devices = this.splitValue(properties.getProperty("PROTEUS_DEVICES"), LIST_SEPARATOR);
        String tmpOsgi = properties.getProperty("START_OSGI_RUNTIME");
        this.startOsgiRuntime = TRUE_STR.equals(tmpOsgi) || tmpOsgi == null && TRUE_STR.equals("false");
        String tmpHttpPort = properties.getProperty("PROTEUS_HTTP_PORT");
        tmpHttpPort = tmpHttpPort == null ? "8082" : tmpHttpPort;
        try {
            this.httpPort = Integer.parseInt(tmpHttpPort);
        }
        catch (NumberFormatException numberFormatException) {
            LOG.error(ERR_PARSE_HTTP_PORT, (Object)"PROTEUS_HTTP_PORT");
        }
    }

    private void setDefaultValues() {
        if (this.port == null) {
            this.port = "8081";
        }
        if (this.realmName == null) {
            this.realmName = "vicciRealm";
        }
        if (this.namespace == null) {
            this.namespace = "vicciWs";
        }
    }

    private List<String> splitValue(String value, String separator) {
        ArrayList<String> tmp = new ArrayList<String>();
        if (value == null) {
            return tmp;
        }
        String[] split = value.split(separator);
        int i = 0;
        while (i < split.length) {
            String out = split[i].trim();
            tmp.add(out);
            ++i;
        }
        return tmp;
    }

    public String getOpenHabUri() {
        return this.openHabUri;
    }

    public String getContextUri() {
        return this.contextUri;
    }

    public String getFeedbackServiceUri() {
        return this.feedbackServiceUri;
    }

    public String getElasticsearchHost() {
        return this.elasticsearchHost;
    }

    public String getSuperPeerIp() {
        return this.superPeerIp;
    }

    public List<String> getDevices() {
        return this.devices;
    }

    public int getHttpPort() {
        return this.httpPort;
    }
}

