/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti.types;

import eu.vicci.process.graphiti.types.DataTypeAddFeature;
import eu.vicci.process.model.sofia.ComplexType;
import eu.vicci.process.model.sofia.DataType;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.impl.AbstractAddFeature;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.RoundedRectangle;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.ui.features.DefaultDeleteFeature;
import org.eclipse.graphiti.util.ColorConstant;
import org.eclipse.graphiti.util.IColorConstant;

public class SubreferenceHelper
extends AbstractAddFeature
implements EObject {
    private final double TRANSPARENCY = 0.2;
    private DataType reference;
    private ComplexType parent;

    public SubreferenceHelper(IFeatureProvider fp, DataType reference, ComplexType parent) {
        super(fp);
        this.reference = reference;
        this.parent = parent;
    }

    public ContainerShape cloneContainer(ContainerShape containerToClone, ContainerShape target) {
        ContainerShape cs = this.cloneGraphicsAlgorithm((Shape)containerToClone, target);
        DataTypeAddFeature.resizeWholeType(this.getDiagram(), (PictogramElement)target);
        return cs;
    }

    private ContainerShape cloneGraphicsAlgorithm(Shape originalShape, ContainerShape targetContainer) {
        if (originalShape instanceof ContainerShape) {
            ContainerShape newContainer = Graphiti.getPeCreateService().createContainerShape(targetContainer, true);
            targetContainer.getChildren().add((Object)newContainer);
            if (originalShape.getGraphicsAlgorithm() instanceof RoundedRectangle) {
                newContainer.setGraphicsAlgorithm((GraphicsAlgorithm)this.cloneRoundedRect((RoundedRectangle)originalShape.getGraphicsAlgorithm(), newContainer));
            }
            if (originalShape.getGraphicsAlgorithm() instanceof Rectangle) {
                newContainer.setGraphicsAlgorithm((GraphicsAlgorithm)this.cloneRect((Rectangle)originalShape.getGraphicsAlgorithm(), newContainer));
            }
            if (originalShape.getGraphicsAlgorithm() instanceof Text) {
                newContainer.setGraphicsAlgorithm((GraphicsAlgorithm)this.cloneText((Text)originalShape.getGraphicsAlgorithm(), newContainer));
            }
            if (originalShape.getGraphicsAlgorithm() instanceof Polyline) {
                newContainer.setGraphicsAlgorithm((GraphicsAlgorithm)this.clonePolyline((Polyline)originalShape.getGraphicsAlgorithm(), newContainer));
            }
            for (Shape child : ((ContainerShape)originalShape).getChildren()) {
                this.cloneGraphicsAlgorithm(child, newContainer);
            }
            return newContainer;
        }
        if (originalShape.getGraphicsAlgorithm() instanceof RoundedRectangle) {
            this.cloneRoundedRect((RoundedRectangle)originalShape.getGraphicsAlgorithm(), targetContainer);
        }
        if (originalShape.getGraphicsAlgorithm() instanceof Rectangle) {
            this.cloneRect((Rectangle)originalShape.getGraphicsAlgorithm(), targetContainer);
        }
        if (originalShape.getGraphicsAlgorithm() instanceof Text) {
            this.cloneText((Text)originalShape.getGraphicsAlgorithm(), targetContainer);
        }
        if (originalShape.getGraphicsAlgorithm() instanceof Polyline) {
            this.clonePolyline((Polyline)originalShape.getGraphicsAlgorithm(), targetContainer);
        }
        return targetContainer;
    }

    private RoundedRectangle cloneRoundedRect(RoundedRectangle original, ContainerShape cs) {
        IGaService gaService = Graphiti.getGaService();
        RoundedRectangle newRR = gaService.createRoundedRectangle((GraphicsAlgorithmContainer)cs, original.getWidth(), original.getHeight());
        newRR.setBackground(this.manageColor((IColorConstant)new ColorConstant(220, 220, 255)));
        newRR.setForeground(original.getForeground());
        newRR.setFilled(Boolean.valueOf(true));
        newRR.setCornerHeight(original.getCornerHeight());
        newRR.setCornerWidth(original.getCornerWidth());
        newRR.setLineWidth(original.getLineWidth());
        newRR.setTransparency(Double.valueOf(0.2));
        gaService.setLocationAndSize((GraphicsAlgorithm)newRR, 10, original.getY(), original.getWidth(), original.getHeight());
        this.link((PictogramElement)cs, (Object)this);
        return newRR;
    }

    private Rectangle cloneRect(Rectangle original, ContainerShape cs) {
        IGaService gaService = Graphiti.getGaService();
        Rectangle newR = gaService.createRectangle((GraphicsAlgorithmContainer)cs);
        newR.setBackground(this.manageColor((IColorConstant)new ColorConstant(220, 220, 255)));
        newR.setForeground(original.getForeground());
        newR.setFilled(Boolean.valueOf(true));
        newR.setLineWidth(original.getLineWidth());
        newR.setTransparency(Double.valueOf(0.2));
        gaService.setLocationAndSize((GraphicsAlgorithm)newR, 10, original.getY(), original.getWidth(), original.getHeight());
        this.link((PictogramElement)cs, (Object)this);
        return newR;
    }

    private Text cloneText(Text original, ContainerShape cs) {
        Shape shape = Graphiti.getPeCreateService().createShape(cs, false);
        IGaService gaService = Graphiti.getGaService();
        Text newText = gaService.createText((GraphicsAlgorithmContainer)shape, original.getValue());
        newText.setBackground(original.getBackground());
        newText.setForeground(original.getForeground());
        newText.setFont(original.getFont());
        newText.setFilled(original.getFilled());
        newText.setLineWidth(original.getLineWidth());
        newText.setTransparency(Double.valueOf(0.2));
        newText.setHorizontalAlignment(original.getHorizontalAlignment());
        newText.setVerticalAlignment(original.getVerticalAlignment());
        if (original.getValue().contains("Type")) {
            newText.setValue(String.valueOf(original.getValue()) + " ref");
        }
        gaService.setLocationAndSize((GraphicsAlgorithm)newText, original.getX(), original.getY(), original.getWidth(), original.getHeight());
        this.link((PictogramElement)shape, (Object)this);
        return newText;
    }

    private Polyline clonePolyline(Polyline original, ContainerShape cs) {
        Shape shape = Graphiti.getPeCreateService().createShape(cs, false);
        IGaService gaService = Graphiti.getGaService();
        Polyline newPL = gaService.createPolyline((GraphicsAlgorithmContainer)shape);
        newPL.setBackground(this.manageColor((IColorConstant)new ColorConstant(220, 220, 255)));
        newPL.setForeground(original.getForeground());
        newPL.setFilled(original.getFilled());
        for (Point p : original.getPoints()) {
            newPL.getPoints().add((Object)gaService.createPoint(p.getX(), p.getY()));
        }
        newPL.setLineWidth(original.getLineWidth());
        newPL.setTransparency(Double.valueOf(0.2));
        gaService.setLocationAndSize((GraphicsAlgorithm)newPL, original.getX(), original.getY(), original.getWidth(), original.getHeight());
        this.link((PictogramElement)shape, (Object)this);
        return newPL;
    }

    public PictogramElement add(IAddContext arg0) {
        return null;
    }

    public boolean canAdd(IAddContext arg0) {
        return false;
    }

    public EList<Adapter> eAdapters() {
        return null;
    }

    public boolean eDeliver() {
        return false;
    }

    public void eSetDeliver(boolean deliver) {
    }

    public void eNotify(Notification notification) {
    }

    public EClass eClass() {
        return null;
    }

    public Resource eResource() {
        return null;
    }

    public EObject eContainer() {
        return null;
    }

    public EStructuralFeature eContainingFeature() {
        return null;
    }

    public EReference eContainmentFeature() {
        return null;
    }

    public EList<EObject> eContents() {
        return null;
    }

    public TreeIterator<EObject> eAllContents() {
        return null;
    }

    public boolean eIsProxy() {
        return false;
    }

    public EList<EObject> eCrossReferences() {
        return null;
    }

    public Object eGet(EStructuralFeature feature) {
        return null;
    }

    public Object eGet(EStructuralFeature feature, boolean resolve) {
        return null;
    }

    public void eSet(EStructuralFeature feature, Object newValue) {
    }

    public boolean eIsSet(EStructuralFeature feature) {
        return false;
    }

    public void eUnset(EStructuralFeature feature) {
    }

    public Object eInvoke(EOperation operation, EList<?> arguments) throws InvocationTargetException {
        return null;
    }

    private static void removeAllChildren(ContainerShape container) {
        int i = 0;
        while (i < container.getChildren().size()) {
            Shape child = (Shape)container.getChildren().get(i);
            if (child instanceof ContainerShape) {
                SubreferenceHelper.removeAllChildren((ContainerShape)child);
            }
            ++i;
        }
        while (container.getChildren().size() > 0) {
            container.getChildren().remove(container.getChildren().size() - 1);
        }
    }

    public DataType getReference() {
        return this.reference;
    }

    public static class SubreferenceDeleteFeature
    extends DefaultDeleteFeature {
        public SubreferenceDeleteFeature(IFeatureProvider fp) {
            super(fp);
        }

        public boolean canDelete(IDeleteContext context) {
            boolean canDelete = super.canDelete(context);
            if (canDelete) {
                Object object = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
                return object instanceof SubreferenceHelper;
            }
            return canDelete;
        }

        public void delete(IDeleteContext context) {
            Object object = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
            if (!(object instanceof SubreferenceHelper)) {
                return;
            }
            SubreferenceHelper sub = (SubreferenceHelper)((Object)object);
            for (DataType ref : sub.parent.getSubreferences()) {
                if (!ref.toString().equals(sub.reference.toString())) continue;
                sub.parent.getSubreferences().remove((Object)ref);
                break;
            }
            block1: for (PictogramElement pe : Graphiti.getLinkService().getPictogramElements(this.getDiagram(), (EObject)sub.parent)) {
                if (!(pe instanceof ContainerShape)) continue;
                ContainerShape cont = (ContainerShape)pe;
                for (Shape child : cont.getChildren()) {
                    if (!(child instanceof ContainerShape)) continue;
                    child.setGraphicsAlgorithm(null);
                    SubreferenceHelper.removeAllChildren((ContainerShape)child);
                    cont.getChildren().remove((Object)child);
                    DataTypeAddFeature.resizeWholeType(this.getDiagram(), (PictogramElement)cont);
                    continue block1;
                }
            }
        }
    }
}

