/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti.types;

import eu.vicci.process.graphiti.AttributeMap;
import eu.vicci.process.graphiti.Util;
import eu.vicci.process.graphiti.types.SubreferenceHelper;
import eu.vicci.process.model.sofia.ComplexType;
import eu.vicci.process.model.sofia.DataType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.impl.LayoutContext;
import org.eclipse.graphiti.features.impl.AbstractAddFeature;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.util.ColorConstant;
import org.eclipse.graphiti.util.IColorConstant;

public abstract class DataTypeAddFeature
extends AbstractAddFeature {
    private static final IColorConstant CLASS_FOREGROUND = new ColorConstant(102, 102, 102);
    private static final IColorConstant CLASS_BACKGROUND = new ColorConstant(230, 230, 230);
    private static final IColorConstant CLASS_TEXT_FOREGROUND = new ColorConstant(0, 0, 0);
    private static int yOffsetInitial = 30;
    private static int width = 100;
    private static int height = 20;
    private String name = "wrong add method";
    static IFeatureProvider fp = null;

    public DataTypeAddFeature(IFeatureProvider fp) {
        super(fp);
        DataTypeAddFeature.fp = fp;
    }

    public boolean canAdd(IAddContext context) {
        return context.getNewObject() instanceof ComplexType;
    }

    public PictogramElement add(IAddContext context) {
        ContainerShape result = this.makeShape(CLASS_BACKGROUND, context, this.name);
        DataTypeAddFeature.resizeWholeType(this.getDiagram(), (PictogramElement)result);
        this.getFeatureProvider().layoutIfPossible((ILayoutContext)new LayoutContext((PictogramElement)result));
        return result;
    }

    public ContainerShape makeShape(IColorConstant backgroundColor, IAddContext context, String name) {
        int index = 0;
        if (context.getTargetContainer() != null) {
            for (Shape child : context.getTargetContainer().getChildren()) {
                if (!(child instanceof ContainerShape)) continue;
                ++index;
            }
        }
        return this.makeShape(index, backgroundColor, context, name);
    }

    public ContainerShape makeShape(int index, IColorConstant backgroundColor, IAddContext context, String name) {
        this.name = name;
        DataType object = (DataType)context.getNewObject();
        int xPosition = context.getX();
        int yPosition = context.getY();
        if (Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement((PictogramElement)context.getTargetContainer()) instanceof ComplexType) {
            xPosition = 10;
            yPosition = DataTypeAddFeature.getYOffsetForIndex(this.getDiagram(), object, index);
        }
        ContainerShape containerShape = Graphiti.getPeCreateService().createContainerShape(context.getTargetContainer(), true);
        IGaService gaService = Graphiti.getGaService();
        Rectangle rectangle = gaService.createPlainRectangle((GraphicsAlgorithmContainer)containerShape);
        rectangle.setForeground(this.manageColor(CLASS_FOREGROUND));
        rectangle.setBackground(this.manageColor(backgroundColor));
        rectangle.setFilled(Boolean.valueOf(true));
        rectangle.setLineWidth(Integer.valueOf(2));
        gaService.setLocationAndSize((GraphicsAlgorithm)rectangle, xPosition, yPosition, width, height);
        this.link((PictogramElement)containerShape, object);
        Shape shape = Graphiti.getPeCreateService().createShape(containerShape, false);
        Text typeText = gaService.createText((GraphicsAlgorithmContainer)shape, name);
        typeText.setForeground(this.manageColor(CLASS_TEXT_FOREGROUND));
        typeText.setHorizontalAlignment(Orientation.ALIGNMENT_LEFT);
        typeText.setFont(gaService.manageDefaultFont(this.getDiagram(), false, true));
        gaService.setLocationAndSize((GraphicsAlgorithm)typeText, 4, 4, width - 8, 12);
        this.link((PictogramElement)shape, object);
        AttributeMap.instance().addObjectMapItem(object, "title", typeText);
        shape = Graphiti.getPeCreateService().createShape(containerShape, false);
        Text nameText = gaService.createText((GraphicsAlgorithmContainer)shape, object.getName());
        nameText = gaService.createText((GraphicsAlgorithmContainer)shape, object.getName());
        nameText.setForeground(this.manageColor(CLASS_TEXT_FOREGROUND));
        nameText.setHorizontalAlignment(Orientation.ALIGNMENT_RIGHT);
        nameText.setFont(gaService.manageDefaultFont(this.getDiagram(), false, true));
        gaService.setLocationAndSize((GraphicsAlgorithm)nameText, 4, 4, width - 8, 12);
        this.link((PictogramElement)shape, object);
        AttributeMap.instance().addObjectMapItem(object, "name", nameText);
        this.getFeatureProvider().getDirectEditingInfo().setActive(true);
        Graphiti.getPeCreateService().createChopboxAnchor((AnchorContainer)containerShape);
        DataTypeAddFeature.resizeWholeType(this.getDiagram(), (PictogramElement)containerShape);
        return containerShape;
    }

    public static int getYOffsetForIndex(Diagram diagram, DataType object, int index) {
        int result = 110;
        if (object.getBelongsTo() == null) {
            return yOffsetInitial;
        }
        ComplexType parent = object.getBelongsTo();
        DataType current = null;
        ContainerShape container = null;
        int i = 0;
        while (i < index) {
            current = (DataType)parent.getSubtypes().get(i);
            container = Util.getContainerForBusinessObject(diagram, current);
            if (container != null) {
                result += container.getGraphicsAlgorithm().getHeight();
            }
            if (i > 0) {
                result += 10;
            }
            ++i;
        }
        return result + yOffsetInitial;
    }

    private static int setPositionsAndCalculateRootWidth(Diagram diagram, DataType root) {
        int result = 0;
        int currentWidth = 0;
        int currentY = yOffsetInitial;
        ArrayList<ContainerShape> usedContainers = new ArrayList<ContainerShape>();
        Map<String, Text> map = AttributeMap.instance().getObjectMap(root);
        Text name = map.get("name");
        name.setValue(root.getName());
        Text title = map.get("title");
        String nameString = name.getValue();
        String titleString = title.getValue();
        result = Util.getTextWidth(diagram, String.valueOf(nameString) + titleString, false, true) + 20;
        if (root instanceof ComplexType && ((ComplexType)root).getSubtypes() != null) {
            ComplexType rootCT = (ComplexType)root;
            ContainerShape rootContainer = Util.getContainerForBusinessObject(diagram, rootCT);
            for (DataType dt : rootCT.getSubreferences()) {
                ArrayList<ContainerShape> dtContainers = Util.getContainersForBusinessObject(diagram, dt);
                SubreferenceHelper sub = new SubreferenceHelper(fp, dt, (ComplexType)root);
                for (ContainerShape dtContainer : dtContainers) {
                    ContainerShape subContainer = null;
                    boolean alreadyExists = false;
                    for (Shape child : rootContainer.getChildren()) {
                        EObject childObj = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement((PictogramElement)child);
                        if (!(childObj instanceof SubreferenceHelper) || ((SubreferenceHelper)childObj).getReference() != dt) continue;
                        alreadyExists = true;
                        if (!(child instanceof ContainerShape)) continue;
                        subContainer = (ContainerShape)child;
                    }
                    if (!alreadyExists) {
                        subContainer = sub.cloneContainer(dtContainer, rootContainer);
                        rootContainer.getChildren().add((Object)subContainer);
                    }
                    if (subContainer == null) continue;
                    subContainer.getGraphicsAlgorithm().setY(currentY);
                    currentY += subContainer.getGraphicsAlgorithm().getHeight() + 10;
                    currentWidth = Math.max(currentWidth, subContainer.getGraphicsAlgorithm().getWidth() + 10);
                }
            }
            map = AttributeMap.instance().getObjectMap(root);
            name = map.get("name");
            title = map.get("title");
            name.setValue(root.getName());
            for (DataType type : ((ComplexType)root).getSubtypes()) {
                map = AttributeMap.instance().getObjectMap(type);
                name = map.get("name");
                title = map.get("title");
                name.setValue(type.getName());
                if (name != null && title != null) {
                    nameString = name.getValue();
                    titleString = title.getValue();
                    currentWidth = Math.max(currentWidth, Util.getTextWidth(diagram, String.valueOf(nameString) + titleString, false, true) + 20);
                    if (type instanceof ComplexType) {
                        currentWidth = Math.max(currentWidth, DataTypeAddFeature.setPositionsAndCalculateRootWidth(diagram, (DataType)((ComplexType)type)) + 20);
                    }
                }
                ArrayList<ContainerShape> containers = Util.getContainersForBusinessObject(diagram, type);
                ContainerShape currentContainer = Util.getContainerForBusinessObject(diagram, type);
                int i = 0;
                while (i < containers.size()) {
                    if (!usedContainers.contains(containers.get(i))) {
                        currentContainer = containers.get(i);
                        usedContainers.add(currentContainer);
                        break;
                    }
                    ++i;
                }
                GraphicsAlgorithm typeGraphic = currentContainer.getGraphicsAlgorithm();
                typeGraphic.setY(currentY);
                currentY += typeGraphic.getHeight() + 10;
            }
            Util.getContainerForBusinessObject(diagram, root).getGraphicsAlgorithm().setHeight(currentY);
        }
        if (currentWidth > result) {
            result = currentWidth;
        }
        return result + 10 - result % 10;
    }

    private static void resizeType(Diagram diagram, PictogramElement rootPe, int width) {
        EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(rootPe);
        Map<String, Text> map = AttributeMap.instance().getObjectMap(bo);
        boolean nomap = false;
        if (map == null) {
            nomap = true;
        }
        if (!nomap) {
            Text text = map.get("name");
            text.setWidth(width - 8);
        }
        rootPe.getGraphicsAlgorithm().setWidth(width);
        if (rootPe instanceof ContainerShape) {
            boolean firstLineFound = false;
            for (Shape s : ((ContainerShape)rootPe).getChildren()) {
                GraphicsAlgorithm ga = s.getGraphicsAlgorithm();
                ga.setWidth(width - 20);
                if (!firstLineFound && ga instanceof Polyline && ((Polyline)ga).getPoints().size() == 2) {
                    ((Point)((Polyline)ga).getPoints().get(1)).setX(width);
                    firstLineFound = true;
                }
                if (ga instanceof Text) {
                    ga.setWidth(width - 10);
                }
                if (!(s instanceof ContainerShape)) continue;
                DataTypeAddFeature.resizeType(diagram, (PictogramElement)s, width - 20);
            }
        }
    }

    public static void resizeWholeType(Diagram diagram, PictogramElement pe) {
        if (!(Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe) instanceof SubreferenceHelper)) {
            DataType bo = (DataType)Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe);
            ComplexType parent = null;
            if (bo == null) {
                return;
            }
            parent = bo.getBelongsTo();
            if (parent != null) {
                List pictogramElements = Graphiti.getLinkService().getPictogramElements(diagram, (EObject)parent);
                for (PictogramElement parentPe : pictogramElements) {
                    if (!(parentPe instanceof ContainerShape)) continue;
                    DataTypeAddFeature.resizeWholeType(diagram, parentPe);
                    return;
                }
            } else if (bo != null) {
                DataTypeAddFeature.resizeType(diagram, pe, DataTypeAddFeature.setPositionsAndCalculateRootWidth(diagram, bo));
            }
        }
    }
}

