/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti.types;

import eu.vicci.process.graphiti.AttributeMap;
import eu.vicci.process.graphiti.Util;
import eu.vicci.process.graphiti.types.DataTypeAddFeature;
import eu.vicci.process.model.sofia.ComplexType;
import eu.vicci.process.model.sofia.Process;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.impl.LayoutContext;
import org.eclipse.graphiti.features.impl.AbstractAddShapeFeature;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.RoundedRectangle;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.Font;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.util.ColorConstant;
import org.eclipse.graphiti.util.IColorConstant;

public class ComplexTypeAddFeature
extends AbstractAddShapeFeature {
    private static final IColorConstant CLASS_FOREGROUND = new ColorConstant(102, 102, 102);
    private static final IColorConstant CLASS_BACKGROUND = new ColorConstant(230, 230, 230);
    private static final IColorConstant CLASS_TEXT_FOREGROUND = new ColorConstant(0, 0, 0);
    private static final String label = "Complex Type";

    public ComplexTypeAddFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canAdd(IAddContext context) {
        return context.getNewObject() instanceof ComplexType && (this.getBusinessObjectForPictogramElement((PictogramElement)context.getTargetContainer()) instanceof Process || this.getBusinessObjectForPictogramElement((PictogramElement)context.getTargetContainer()) instanceof ComplexType);
    }

    public PictogramElement add(IAddContext context) {
        ComplexType object = (ComplexType)context.getNewObject();
        IGaService gaService = Graphiti.getGaService();
        Font titleFont = gaService.manageDefaultFont(this.getDiagram(), false, true);
        int textWidth = Util.getTextWidth(this.getDiagram(), "Complex Type " + object.getName(), titleFont);
        int width = Math.max(120, textWidth);
        int height = 40;
        ContainerShape containerShape = Graphiti.getPeCreateService().createContainerShape(context.getTargetContainer(), true);
        RoundedRectangle roundedRectangle = gaService.createPlainRoundedRectangle((GraphicsAlgorithmContainer)containerShape, 10, 10);
        roundedRectangle.setForeground(this.manageColor(CLASS_FOREGROUND));
        roundedRectangle.setBackground(this.manageColor(CLASS_BACKGROUND));
        roundedRectangle.setFilled(Boolean.valueOf(true));
        roundedRectangle.setLineWidth(Integer.valueOf(2));
        this.link((PictogramElement)containerShape, object);
        Shape lineShape = Graphiti.getPeCreateService().createShape(containerShape, false);
        int[] nArray = new int[4];
        nArray[1] = 20;
        nArray[2] = width;
        nArray[3] = 20;
        Polyline polyline = gaService.createPolyline((GraphicsAlgorithmContainer)lineShape, nArray);
        polyline.setForeground(this.manageColor(CLASS_FOREGROUND));
        polyline.setLineWidth(Integer.valueOf(2));
        this.link((PictogramElement)lineShape, object);
        Shape shape = Graphiti.getPeCreateService().createShape(containerShape, false);
        Text titleText = gaService.createText((GraphicsAlgorithmContainer)shape, label);
        titleText.setForeground(this.manageColor(CLASS_TEXT_FOREGROUND));
        titleText.setHorizontalAlignment(Orientation.ALIGNMENT_LEFT);
        titleText.setFont(titleFont);
        gaService.setLocationAndSize((GraphicsAlgorithm)titleText, 4, 4, width - 8, 12);
        this.link((PictogramElement)shape, object);
        AttributeMap.instance().addObjectMapItem(object, "title", titleText);
        shape = Graphiti.getPeCreateService().createShape(containerShape, false);
        Text nameText = gaService.createText((GraphicsAlgorithmContainer)shape, object.getName());
        nameText.setForeground(this.manageColor(CLASS_TEXT_FOREGROUND));
        nameText.setHorizontalAlignment(Orientation.ALIGNMENT_RIGHT);
        nameText.setFont(titleFont);
        gaService.setLocationAndSize((GraphicsAlgorithm)nameText, 0, 4, width - 8, 12);
        this.link((PictogramElement)shape, object);
        AttributeMap.instance().addObjectMapItem(object, "name", nameText);
        this.getFeatureProvider().getDirectEditingInfo().setActive(true);
        Graphiti.getPeCreateService().createChopboxAnchor((AnchorContainer)containerShape);
        ComplexType target = object.getBelongsTo();
        if (target != null) {
            gaService.setLocationAndSize((GraphicsAlgorithm)roundedRectangle, 10, 30, width, height);
            DataTypeAddFeature.resizeWholeType(this.getDiagram(), (PictogramElement)Util.getContainerForBusinessObject(this.getDiagram(), target));
        } else {
            gaService.setLocationAndSize((GraphicsAlgorithm)roundedRectangle, context.getX(), context.getY(), width, height);
        }
        DataTypeAddFeature.resizeWholeType(this.getDiagram(), (PictogramElement)containerShape);
        this.getFeatureProvider().layoutIfPossible((ILayoutContext)new LayoutContext((PictogramElement)containerShape));
        return containerShape;
    }
}

