/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti.sofiagraphics;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Alignment implements Enumerator
{
    CENTER(0, "CENTER", "CENTER"),
    LEFT(1, "LEFT", "LEFT"),
    TOP(2, "TOP", "TOP"),
    RIGHT(3, "RIGHT", "RIGHT"),
    BOTTOM(4, "BOTTOM", "BOTTOM"),
    MIDDLE(5, "MIDDLE", "MIDDLE"),
    UNSPECIFIED(6, "UNSPECIFIED", "UNSPECIFIED");

    public static final int CENTER_VALUE = 0;
    public static final int LEFT_VALUE = 1;
    public static final int TOP_VALUE = 2;
    public static final int RIGHT_VALUE = 3;
    public static final int BOTTOM_VALUE = 4;
    public static final int MIDDLE_VALUE = 5;
    public static final int UNSPECIFIED_VALUE = 6;
    private static final Alignment[] VALUES_ARRAY;
    public static final List<Alignment> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Alignment[]{CENTER, LEFT, TOP, RIGHT, BOTTOM, MIDDLE, UNSPECIFIED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Alignment get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Alignment result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Alignment getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Alignment result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Alignment get(int value) {
        switch (value) {
            case 0: {
                return CENTER;
            }
            case 1: {
                return LEFT;
            }
            case 2: {
                return TOP;
            }
            case 3: {
                return RIGHT;
            }
            case 4: {
                return BOTTOM;
            }
            case 5: {
                return MIDDLE;
            }
            case 6: {
                return UNSPECIFIED;
            }
        }
        return null;
    }

    private Alignment(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

