/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti.property;

import eu.vicci.process.graphiti.AttributeMap;
import eu.vicci.process.graphiti.ProcessFeatureProvider;
import eu.vicci.process.graphiti.property.PropertySectionBase;
import eu.vicci.process.model.sofia.XMLRPCInvoke;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.impl.LayoutContext;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class XMLRPCInvokeSection
extends PropertySectionBase {
    private Text serverText;
    private Text methodText;
    private Text startParameterText;
    private Text endParameterText;

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory factory = this.getWidgetFactory();
        Composite composite = factory.createFlatFormComposite(parent);
        this.serverText = factory.createText(composite, "");
        this.serverText.setEditable(true);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this.serverText.setLayoutData((Object)data);
        this.serverText.addFocusListener((FocusListener)new StateFocusListener());
        this.serverText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    new StateFocusListener().focusLost(null);
                }
            }
        });
        CLabel valueLabel = factory.createCLabel(composite, "Server URI:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.serverText, -5);
        data.top = new FormAttachment((Control)this.serverText, 0, 0x1000000);
        valueLabel.setLayoutData((Object)data);
        composite = factory.createFlatFormComposite(parent);
        this.methodText = factory.createText(composite, "");
        this.methodText.setEditable(true);
        data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this.methodText.setLayoutData((Object)data);
        this.methodText.addFocusListener((FocusListener)new StateFocusListener());
        this.methodText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    new StateFocusListener().focusLost(null);
                }
            }
        });
        valueLabel = factory.createCLabel(composite, "Method:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.methodText, -5);
        data.top = new FormAttachment((Control)this.methodText, 0, 0x1000000);
        valueLabel.setLayoutData((Object)data);
        composite = factory.createFlatFormComposite(parent);
        this.startParameterText = factory.createText(composite, "");
        this.startParameterText.setEditable(true);
        data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this.startParameterText.setLayoutData((Object)data);
        this.startParameterText.addFocusListener((FocusListener)new StateFocusListener());
        this.startParameterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    new StateFocusListener().focusLost(null);
                }
            }
        });
        valueLabel = factory.createCLabel(composite, "Start Param. Seq.:");
        valueLabel.setToolTipText("Start Parameter Sequence");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.startParameterText, -5);
        data.top = new FormAttachment((Control)this.startParameterText, 0, 0x1000000);
        valueLabel.setLayoutData((Object)data);
        composite = factory.createFlatFormComposite(parent);
        this.endParameterText = factory.createText(composite, "");
        this.endParameterText.setEditable(true);
        data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this.endParameterText.setLayoutData((Object)data);
        this.endParameterText.addFocusListener((FocusListener)new StateFocusListener());
        this.endParameterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    new StateFocusListener().focusLost(null);
                }
            }
        });
        valueLabel = factory.createCLabel(composite, "End Param. Seq.:");
        valueLabel.setToolTipText("End Parameter Sequence");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.endParameterText, -5);
        data.top = new FormAttachment((Control)this.endParameterText, 0, 0x1000000);
        valueLabel.setLayoutData((Object)data);
    }

    public void refresh() {
        EObject bo;
        PictogramElement pe = this.getSelectedPictogramElement();
        if (pe != null && (bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe)) instanceof XMLRPCInvoke) {
            String s = ((XMLRPCInvoke)bo).getServerUri();
            this.serverText.setText(s == null ? "" : s);
            s = ((XMLRPCInvoke)bo).getMethodName();
            this.methodText.setText(s == null ? "" : s);
            s = ((XMLRPCInvoke)bo).getStartParameterSequence();
            this.startParameterText.setText(s == null ? "" : s);
            s = ((XMLRPCInvoke)bo).getEndParameterSequence();
            this.endParameterText.setText(s == null ? "" : s);
        }
    }

    private class StateFocusListener
    implements FocusListener {
        private StateFocusListener() {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            final PictogramElement pe = XMLRPCInvokeSection.this.getSelectedPictogramElement();
            if (pe != null) {
                final EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe);
                final Map<String, org.eclipse.graphiti.mm.algorithms.Text> map = AttributeMap.instance().getObjectMap(bo);
                if (bo instanceof XMLRPCInvoke) {
                    TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((Object)bo);
                    editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){
                        ProcessFeatureProvider featureProvider;
                        {
                            super($anonymous0);
                            this.featureProvider = XMLRPCInvokeSection.this.getProcessFeatureProvider();
                        }

                        protected void doExecute() {
                            org.eclipse.graphiti.mm.algorithms.Text text;
                            String s = XMLRPCInvokeSection.this.serverText.getText();
                            if (s != null) {
                                if (map != null && (text = (org.eclipse.graphiti.mm.algorithms.Text)map.get("server")) != null) {
                                    text.setValue("server: " + s);
                                }
                                ((XMLRPCInvoke)bo).setServerUri(s);
                            }
                            if ((s = XMLRPCInvokeSection.this.methodText.getText()) != null) {
                                if (map != null && (text = (org.eclipse.graphiti.mm.algorithms.Text)map.get("method")) != null) {
                                    text.setValue("method: " + s);
                                }
                                ((XMLRPCInvoke)bo).setMethodName(s);
                            }
                            if ((s = XMLRPCInvokeSection.this.startParameterText.getText()) != null) {
                                if (map != null && (text = (org.eclipse.graphiti.mm.algorithms.Text)map.get("startseq")) != null) {
                                    text.setValue("start sequence: " + s);
                                }
                                ((XMLRPCInvoke)bo).setStartParameterSequence(s);
                            }
                            if ((s = XMLRPCInvokeSection.this.endParameterText.getText()) != null) {
                                if (map != null && (text = (org.eclipse.graphiti.mm.algorithms.Text)map.get("endseq")) != null) {
                                    text.setValue("end sequence: " + s);
                                }
                                ((XMLRPCInvoke)bo).setEndParameterSequence(s);
                            }
                            this.featureProvider.layoutIfPossible((ILayoutContext)new LayoutContext(pe));
                        }
                    });
                }
            }
        }
    }
}

