/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti.property;

import eu.vicci.process.graphiti.AttributeMap;
import eu.vicci.process.graphiti.ProcessFeatureProvider;
import eu.vicci.process.graphiti.property.PropertySectionBase;
import eu.vicci.process.model.sofia.ProcessStep;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.impl.LayoutContext;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class TypeSection
extends PropertySectionBase {
    private Text typeText;
    private Text description;
    private Text resource;

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory factory = this.getWidgetFactory();
        Composite composite = factory.createFlatFormComposite(parent);
        this.typeText = factory.createText(composite, "");
        this.typeText.setEditable(true);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment(50, 0);
        data.top = new FormAttachment(0, 4);
        this.typeText.setLayoutData((Object)data);
        this.typeText.addFocusListener((FocusListener)new StateFocusListener());
        this.typeText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    new StateFocusListener().focusLost(null);
                }
            }
        });
        CLabel valueLabel = factory.createCLabel(composite, "Type:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.typeText, -5);
        data.top = new FormAttachment((Control)this.typeText, 0, 0x1000000);
        valueLabel.setLayoutData((Object)data);
        this.resource = factory.createText(composite, "");
        this.resource.setEditable(true);
        data = new FormData();
        data.left = new FormAttachment((Control)this.typeText, 85);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this.resource.setLayoutData((Object)data);
        this.resource.addFocusListener((FocusListener)new StateFocusListener());
        this.resource.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    new StateFocusListener().focusLost(null);
                }
            }
        });
        valueLabel = factory.createCLabel(composite, "Resource:");
        data = new FormData();
        data.left = new FormAttachment((Control)this.typeText, 0);
        data.right = new FormAttachment((Control)this.resource, -5);
        data.top = new FormAttachment((Control)this.resource, 0, 0x1000000);
        valueLabel.setLayoutData((Object)data);
        composite = factory.createFlatFormComposite(parent);
        this.description = factory.createText(composite, "");
        this.description.setEditable(true);
        data = new FormData();
        data.left = new FormAttachment((Control)this.resource, 85);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this.description.setLayoutData((Object)data);
        this.description.addFocusListener((FocusListener)new StateFocusListener());
        this.description.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    new StateFocusListener().focusLost(null);
                }
            }
        });
        CLabel descriptionLabel = factory.createCLabel(composite, "Description:");
        data = new FormData();
        data.left = new FormAttachment((Control)this.resource, 0);
        data.right = new FormAttachment((Control)this.description, -5);
        data.top = new FormAttachment((Control)this.description, 0, 0x1000000);
        descriptionLabel.setLayoutData((Object)data);
    }

    public void refresh() {
        EObject bo;
        PictogramElement pe = this.getSelectedPictogramElement();
        if (pe != null && (bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe)) instanceof ProcessStep) {
            ProcessStep processStep = (ProcessStep)bo;
            String type = processStep.getType();
            this.typeText.setText(type == null ? "" : type);
            String desc = processStep.getDescription();
            this.description.setText(desc == null ? "" : desc);
            String res = processStep.getResource();
            this.resource.setText(res == null ? "" : res);
        }
    }

    private class StateFocusListener
    implements FocusListener {
        private StateFocusListener() {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            final PictogramElement pe = TypeSection.this.getSelectedPictogramElement();
            if (pe != null) {
                final EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe);
                final Map<String, org.eclipse.graphiti.mm.algorithms.Text> map = AttributeMap.instance().getObjectMap(bo);
                if (bo instanceof ProcessStep) {
                    TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((Object)bo);
                    editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){
                        ProcessFeatureProvider featureProvider;
                        {
                            super($anonymous0);
                            this.featureProvider = TypeSection.this.getProcessFeatureProvider();
                        }

                        protected void doExecute() {
                            org.eclipse.graphiti.mm.algorithms.Text text;
                            String type = TypeSection.this.typeText.getText();
                            String description = TypeSection.this.description.getText();
                            String resour = TypeSection.this.resource.getText();
                            if (type != null) {
                                ((ProcessStep)bo).setType(type);
                                if (map != null && (text = (org.eclipse.graphiti.mm.algorithms.Text)map.get("type")) != null) {
                                    text.setValue("type: " + type);
                                }
                            }
                            if (description != null) {
                                ((ProcessStep)bo).setDescription(description);
                            }
                            if (resour != null) {
                                ((ProcessStep)bo).setResource(resour);
                                if (map != null && (text = (org.eclipse.graphiti.mm.algorithms.Text)map.get("resource")) != null) {
                                    text.setValue("resource: " + resour);
                                }
                            }
                            this.featureProvider.layoutIfPossible((ILayoutContext)new LayoutContext(pe));
                        }
                    });
                }
            }
        }
    }
}

