/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti.property;

import eu.vicci.process.graphiti.AttributeMap;
import eu.vicci.process.graphiti.ProcessFeatureProvider;
import eu.vicci.process.graphiti.Util;
import eu.vicci.process.graphiti.WsdlTypeImporter;
import eu.vicci.process.graphiti.property.PropertySectionBase;
import eu.vicci.process.model.sofia.CompositeStep;
import eu.vicci.process.model.sofia.ProcessStep;
import eu.vicci.process.model.sofia.SOAPInvoke;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.impl.LayoutContext;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class SOAPInvokeSection
extends PropertySectionBase {
    private Text serverText;
    private Text methodText;
    private Text wsdlText;
    private Text configText;

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory factory = this.getWidgetFactory();
        Composite composite = factory.createFlatFormComposite(parent);
        this.serverText = factory.createText(composite, "");
        this.serverText.setEditable(true);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this.serverText.setLayoutData((Object)data);
        this.serverText.addFocusListener((FocusListener)new StateFocusListener());
        this.serverText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    new StateFocusListener().focusLost(null);
                }
            }
        });
        CLabel valueLabel = factory.createCLabel(composite, "Server URI:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.serverText, -5);
        data.top = new FormAttachment((Control)this.serverText, 0, 0x1000000);
        valueLabel.setLayoutData((Object)data);
        composite = factory.createFlatFormComposite(parent);
        this.methodText = factory.createText(composite, "");
        this.methodText.setEditable(true);
        data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this.methodText.setLayoutData((Object)data);
        this.methodText.addFocusListener((FocusListener)new StateFocusListener());
        this.methodText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    new StateFocusListener().focusLost(null);
                }
            }
        });
        valueLabel = factory.createCLabel(composite, "Method:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.methodText, -5);
        data.top = new FormAttachment((Control)this.methodText, 0, 0x1000000);
        valueLabel.setLayoutData((Object)data);
        composite = factory.createFlatFormComposite(parent);
        this.wsdlText = factory.createText(composite, "");
        this.wsdlText.setEditable(true);
        data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this.wsdlText.setLayoutData((Object)data);
        this.wsdlText.addFocusListener((FocusListener)new StateFocusListener());
        this.wsdlText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    new StateFocusListener().focusLost(null);
                }
            }
        });
        valueLabel = factory.createCLabel(composite, "WSDL Uri:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.wsdlText, -5);
        data.top = new FormAttachment((Control)this.wsdlText, 0, 0x1000000);
        valueLabel.setLayoutData((Object)data);
        composite = factory.createFlatFormComposite(parent);
        this.configText = factory.createText(composite, "");
        this.configText.setEditable(true);
        data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this.configText.setLayoutData((Object)data);
        this.configText.addFocusListener((FocusListener)new StateFocusListener());
        this.configText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    new StateFocusListener().focusLost(null);
                }
            }
        });
        valueLabel = factory.createCLabel(composite, "Config File:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.configText, -5);
        data.top = new FormAttachment((Control)this.configText, 0, 0x1000000);
        valueLabel.setLayoutData((Object)data);
    }

    public void refresh() {
        EObject bo;
        PictogramElement pe = this.getSelectedPictogramElement();
        if (pe != null && (bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe)) instanceof SOAPInvoke) {
            String s = ((SOAPInvoke)bo).getServerUri();
            this.serverText.setText(s == null ? "" : s);
            s = ((SOAPInvoke)bo).getMethodName();
            this.methodText.setText(s == null ? "" : s);
            s = ((SOAPInvoke)bo).getWsdlUri();
            this.wsdlText.setText(s == null ? "" : s);
            s = ((SOAPInvoke)bo).getConfigFile();
            this.configText.setText(s == null ? "" : s);
        }
    }

    private class StateFocusListener
    implements FocusListener {
        private StateFocusListener() {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            final PictogramElement pe = SOAPInvokeSection.this.getSelectedPictogramElement();
            if (pe != null) {
                final EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe);
                final Map<String, org.eclipse.graphiti.mm.algorithms.Text> map = AttributeMap.instance().getObjectMap(bo);
                if (bo instanceof SOAPInvoke) {
                    TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((Object)bo);
                    editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){
                        ProcessFeatureProvider featureProvider;
                        {
                            super($anonymous0);
                            this.featureProvider = SOAPInvokeSection.this.getProcessFeatureProvider();
                        }

                        protected void doExecute() {
                            org.eclipse.graphiti.mm.algorithms.Text text;
                            String s = SOAPInvokeSection.this.serverText.getText();
                            if (s != null) {
                                if (map != null && (text = (org.eclipse.graphiti.mm.algorithms.Text)map.get("server")) != null) {
                                    text.setValue("server: " + s);
                                }
                                ((SOAPInvoke)bo).setServerUri(s);
                            }
                            if ((s = SOAPInvokeSection.this.methodText.getText()) != null) {
                                if (map != null && (text = (org.eclipse.graphiti.mm.algorithms.Text)map.get("method")) != null) {
                                    text.setValue("method: " + s);
                                    System.out.println("width: " + text.getWidth());
                                }
                                ((SOAPInvoke)bo).setMethodName(s);
                            }
                            if ((s = SOAPInvokeSection.this.wsdlText.getText()) != null) {
                                if (map != null && (text = (org.eclipse.graphiti.mm.algorithms.Text)map.get("wsdl")) != null) {
                                    text.setValue("wsdl: " + s);
                                    System.out.println("width: " + text.getWidth());
                                }
                                if (!s.equals(((SOAPInvoke)bo).getWsdlUri())) {
                                    ((SOAPInvoke)bo).setWsdlUri(s);
                                    System.out.println("s = " + s + "  wsdlUri = " + ((SOAPInvoke)bo).getWsdlUri());
                                    CompositeStep rootParent = ((SOAPInvoke)bo).getParentstep();
                                    while (rootParent.getParentstep() != null && rootParent instanceof ProcessStep && rootParent != rootParent.getParentstep()) {
                                        rootParent = rootParent.getParentstep();
                                    }
                                    WsdlTypeImporter.parse(s, this.featureProvider, Util.getContainerForBusinessObject(SOAPInvokeSection.this.getDiagram(), rootParent), SOAPInvokeSection.this.getDiagram());
                                }
                            }
                            if ((s = SOAPInvokeSection.this.configText.getText()) != null) {
                                if (map != null && (text = (org.eclipse.graphiti.mm.algorithms.Text)map.get("config")) != null) {
                                    text.setValue("config: " + s);
                                    System.out.println("width: " + text.getWidth());
                                }
                                ((SOAPInvoke)bo).setConfigFile(s);
                            }
                            this.featureProvider.layoutIfPossible((ILayoutContext)new LayoutContext(pe));
                        }
                    });
                }
            }
        }
    }
}

