/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti.property;

import eu.vicci.process.graphiti.ProcessFeatureProvider;
import eu.vicci.process.graphiti.property.PropertySectionBase;
import eu.vicci.process.model.sofia.EndDataPort;
import eu.vicci.process.model.sofia.Loop;
import eu.vicci.process.model.sofia.Port;
import eu.vicci.process.model.sofia.StartDataPort;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.impl.LayoutContext;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class LoopSection
extends PropertySectionBase {
    private TabbedPropertySheetWidgetFactory factory;
    private Composite flatFormComposite;
    private Table copyTable;
    private TableViewer copyTableViewer;
    private Group copyGroup;
    private Button addNewDropDownsButton;
    private Map<EndDataPort, StartDataPort> portsToCopy = new HashMap<EndDataPort, StartDataPort>();
    private Map<Object, CCombo> combos = new HashMap<Object, CCombo>();
    private Map<Object, Button> buttons = new HashMap<Object, Button>();
    private List<Port> startDataPorts = new ArrayList<Port>();
    private List<Port> endDataPorts = new ArrayList<Port>();

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.factory = this.getWidgetFactory();
        this.flatFormComposite = this.factory.createFlatFormComposite(parent);
        this.copyGroup = this.factory.createGroup(this.flatFormComposite, "Values to Copy on each step");
        FillLayout layout = new FillLayout(10);
        layout.marginHeight = 20;
        layout.marginWidth = 20;
        layout.spacing = 10;
        this.copyGroup.setLayout((Layout)layout);
        this.createTable();
        this.createAddButton();
        this.copyGroup.pack();
        this.copyGroup.update();
    }

    public void refresh() {
        super.refresh();
        Loop loop = this.getLoopElement();
        this.startDataPorts.clear();
        this.endDataPorts.clear();
        this.portsToCopy.clear();
        if (loop == null) {
            return;
        }
        this.portsToCopy.putAll(loop.getPortsCopyToStartsport().map());
        for (Port port : loop.getPorts()) {
            if (!(port instanceof StartDataPort)) continue;
            this.startDataPorts.add(port);
        }
        for (Port port : loop.getPorts()) {
            if (!(port instanceof EndDataPort) || this.portsToCopy.containsKey(port)) continue;
            this.endDataPorts.add(port);
        }
        this.copyTableViewer.setInput(this.portsToCopy.entrySet());
    }

    private void createAddButton() {
        this.addNewDropDownsButton = this.factory.createButton((Composite)this.copyGroup, "add copy", 8);
        this.addNewDropDownsButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                LoopSection.this.onAddButtonClick(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                LoopSection.this.onAddButtonClick(e);
            }
        });
        this.addNewDropDownsButton.pack();
        this.addNewDropDownsButton.update();
    }

    private void onAddButtonClick(SelectionEvent e) {
        if (!this.portsToCopy.containsKey(null)) {
            this.portsToCopy.put(null, null);
        }
        this.copyTableViewer.refresh();
    }

    private void createTable() {
        this.copyTableViewer = new TableViewer((Composite)this.copyGroup);
        this.copyTable = this.copyTableViewer.getTable();
        TableColumn left = new TableColumn(this.copyTable, 0x1000000);
        TableColumn center = new TableColumn(this.copyTable, 0x1000000);
        TableColumn right = new TableColumn(this.copyTable, 0x1000000);
        left.setWidth(500);
        center.setWidth(500);
        right.setWidth(100);
        left.setText("from endport");
        center.setText("to startport");
        right.setText("remove");
        this.copyTable.setHeaderVisible(true);
        this.copyTable.pack();
        TableViewerColumn leftTVC = new TableViewerColumn(this.copyTableViewer, left);
        leftTVC.setLabelProvider((CellLabelProvider)new CustomComboLabelProvider());
        TableViewerColumn centerTVC = new TableViewerColumn(this.copyTableViewer, center);
        centerTVC.setLabelProvider((CellLabelProvider)new CustomComboLabelProvider());
        TableViewerColumn rightTVC = new TableViewerColumn(this.copyTableViewer, right);
        rightTVC.setLabelProvider((CellLabelProvider)new CustomButtonLabelProvider());
        this.copyTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.copyTableViewer.refresh();
    }

    private void onRemoveButtonClick(SelectionEvent e) {
        if (e.widget == null) {
            return;
        }
        Map.Entry entry = (Map.Entry)e.widget.getData();
        Object key = entry.getKey();
        this.portsToCopy.remove(key);
        for (Button b : this.buttons.values()) {
            b.dispose();
        }
        this.buttons.clear();
        for (CCombo c : this.combos.values()) {
            c.dispose();
        }
        this.combos.clear();
        Loop loop = this.getLoopElement();
        if (loop != null) {
            this.writeToModel(loop);
            this.refresh();
        }
        this.copyTableViewer.refresh();
    }

    private void writeToModel(final Loop loop) {
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)loop);
        editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){
            ProcessFeatureProvider featureProvider;
            {
                super($anonymous0);
                this.featureProvider = LoopSection.this.getProcessFeatureProvider();
            }

            protected void doExecute() {
                try {
                    loop.getPortsCopyToStartsport().clear();
                    loop.getPortsCopyToStartsport().map().putAll(LoopSection.this.portsToCopy);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                this.featureProvider.layoutIfPossible((ILayoutContext)new LayoutContext(LoopSection.this.getSelectedPictogramElement()));
            }
        });
    }

    private void onComboFocusLostOrWidgetSelected(TypedEvent e, int column) {
        CCombo combo = (CCombo)e.widget;
        Loop loop = this.getLoopElement();
        if (loop == null) {
            return;
        }
        if (combo.getSelectionIndex() == -1) {
            return;
        }
        EndDataPort key = (EndDataPort)combo.getData();
        if (column == 0) {
            StartDataPort old = null;
            EndDataPort port = (EndDataPort)this.endDataPorts.get(combo.getSelectionIndex());
            if (key == null) {
                old = this.portsToCopy.remove(null);
                key = port;
                combo.setData((Object)key);
            }
            this.portsToCopy.put(key, old);
        } else {
            StartDataPort port = (StartDataPort)this.startDataPorts.get(combo.getSelectionIndex());
            this.portsToCopy.put(key, port);
        }
        if (key != null && this.portsToCopy.get(key) != null) {
            this.writeToModel(loop);
            this.refresh();
        }
        this.copyTableViewer.refresh();
    }

    private Loop getLoopElement() {
        EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(this.getSelectedPictogramElement());
        if (bo != null) {
            return (Loop)bo;
        }
        return null;
    }

    private class CustomButtonLabelProvider
    extends ColumnLabelProvider {
        private CustomButtonLabelProvider() {
        }

        public void update(ViewerCell cell) {
            TableItem item = (TableItem)cell.getItem();
            Button button = LoopSection.this.buttons.containsKey(cell) ? (Button)LoopSection.this.buttons.get(cell) : this.createButton(cell, item);
            button.setData(item.getData());
            TableEditor editor = new TableEditor(item.getParent());
            editor.grabHorizontal = true;
            editor.grabVertical = true;
            editor.setEditor((Control)button, item, cell.getColumnIndex());
            editor.layout();
        }

        private Button createButton(ViewerCell cell, TableItem item) {
            Button button = new Button((Composite)cell.getViewerRow().getControl(), 0);
            button.setText("Remove");
            button.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    LoopSection.this.onRemoveButtonClick(e);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    LoopSection.this.onRemoveButtonClick(e);
                }
            });
            LoopSection.this.buttons.put(cell, button);
            return button;
        }
    }

    private class CustomComboLabelProvider
    extends ColumnLabelProvider {
        private CustomComboLabelProvider() {
        }

        public void update(ViewerCell cell) {
            TableItem item = (TableItem)cell.getItem();
            Map.Entry portEntry = (Map.Entry)item.getData();
            Port key = (Port)portEntry.getKey();
            Port value = (Port)portEntry.getValue();
            CCombo combo = LoopSection.this.combos.containsKey(cell) ? (CCombo)LoopSection.this.combos.get(cell) : this.createCombo(cell, item, cell.getColumnIndex());
            if (cell.getColumnIndex() == 0) {
                this.setComboTextAndValue(key, combo, cell.getColumnIndex());
            } else if (cell.getColumnIndex() == 1) {
                this.setComboTextAndValue(value, combo, cell.getColumnIndex());
            }
            combo.setData((Object)key);
            if (combo.getText().equals("select port!")) {
                combo.setEnabled(true);
            } else {
                combo.setEnabled(false);
            }
            TableEditor editor = new TableEditor(item.getParent());
            editor.grabHorizontal = true;
            editor.grabVertical = true;
            editor.setEditor((Control)combo, item, cell.getColumnIndex());
            editor.layout();
        }

        private void setComboTextAndValue(Port port, CCombo combo, int column) {
            combo.removeAll();
            List toAdd = null;
            toAdd = column == 0 ? LoopSection.this.endDataPorts : LoopSection.this.startDataPorts;
            for (Port p : toAdd) {
                combo.add(p.getName());
            }
            if (port == null || port.getName() == null || port.getName().isEmpty()) {
                combo.setText("select port!");
            } else {
                combo.setText(port.getName());
            }
        }

        private CCombo createCombo(ViewerCell cell, TableItem item, final int column) {
            CCombo combo = LoopSection.this.factory.createCCombo((Composite)cell.getViewerRow().getControl());
            combo.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                    LoopSection.this.onComboFocusLostOrWidgetSelected((TypedEvent)e, column);
                }

                public void focusGained(FocusEvent e) {
                }
            });
            LoopSection.this.combos.put(cell, combo);
            return combo;
        }
    }
}

