/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti.property;

import eu.vicci.process.graphiti.ProcessFeatureProvider;
import eu.vicci.process.graphiti.property.PropertySectionBase;
import eu.vicci.process.graphiti.types.DataTypeAddFeature;
import eu.vicci.process.model.sofia.IntegerType;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.impl.LayoutContext;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class IntegerTypeSection
extends PropertySectionBase {
    private Text minText;
    private Text maxText;

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory factory = this.getWidgetFactory();
        Composite composite = factory.createFlatFormComposite(parent);
        this.minText = factory.createText(composite, "");
        this.minText.setEditable(true);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this.minText.setLayoutData((Object)data);
        this.minText.addFocusListener((FocusListener)new StateFocusListener());
        this.minText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    new StateFocusListener().focusLost(null);
                }
            }
        });
        CLabel valueLabel = factory.createCLabel(composite, "Minimum:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.minText, -5);
        data.top = new FormAttachment((Control)this.minText, 0, 0x1000000);
        valueLabel.setLayoutData((Object)data);
        composite = factory.createFlatFormComposite(parent);
        this.maxText = factory.createText(composite, "");
        this.maxText.setEditable(true);
        data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this.maxText.setLayoutData((Object)data);
        this.maxText.addFocusListener((FocusListener)new StateFocusListener());
        this.maxText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    new StateFocusListener().focusLost(null);
                }
            }
        });
        valueLabel = factory.createCLabel(composite, "Maximum:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.maxText, -5);
        data.top = new FormAttachment((Control)this.maxText, 0, 0x1000000);
        valueLabel.setLayoutData((Object)data);
        this.minText.addVerifyListener((VerifyListener)new NumberVerifier());
        this.maxText.addVerifyListener((VerifyListener)new NumberVerifier());
    }

    public void refresh() {
        PictogramElement pe = this.getSelectedPictogramElement();
        if (pe != null) {
            EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe);
            String min = null;
            String max = null;
            if (bo instanceof IntegerType) {
                min = String.valueOf(((IntegerType)bo).getMin());
                max = String.valueOf(((IntegerType)bo).getMax());
            }
            this.minText.setText(min == null ? "" : min);
            this.maxText.setText(max == null ? "" : max);
        }
    }

    private class NumberVerifier
    implements VerifyListener {
        private NumberVerifier() {
        }

        public void verifyText(VerifyEvent e) {
            try {
                Integer.parseInt(e.text);
            }
            catch (NumberFormatException numberFormatException) {
                e.doit = false;
            }
        }
    }

    private class StateFocusListener
    implements FocusListener {
        private StateFocusListener() {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            EObject bo;
            final PictogramElement pe = IntegerTypeSection.this.getSelectedPictogramElement();
            if (pe != null && (bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe)) instanceof IntegerType) {
                TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((Object)bo);
                editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){
                    ProcessFeatureProvider featureProvider;
                    {
                        super($anonymous0);
                        this.featureProvider = IntegerTypeSection.this.getProcessFeatureProvider();
                    }

                    protected void doExecute() {
                        String max;
                        String min = IntegerTypeSection.this.minText.getText();
                        if (min != null) {
                            try {
                                ((IntegerType)bo).setMin(Integer.parseInt(min));
                            }
                            catch (NumberFormatException numberFormatException) {
                                System.out.println(String.valueOf(min) + " is not an Integer");
                            }
                        }
                        if ((max = IntegerTypeSection.this.maxText.getText()) != null) {
                            try {
                                ((IntegerType)bo).setMax(Integer.parseInt(max));
                            }
                            catch (NumberFormatException numberFormatException) {
                                System.out.println(String.valueOf(max) + " is not an Integer");
                            }
                        }
                        try {
                            DataTypeAddFeature.resizeWholeType(IntegerTypeSection.this.getDiagram(), pe);
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                        this.featureProvider.layoutIfPossible((ILayoutContext)new LayoutContext(pe));
                    }
                });
            }
        }
    }
}

