/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti.property;

import eu.vicci.process.graphiti.ProcessFeatureProvider;
import eu.vicci.process.graphiti.property.PropertySectionBase;
import eu.vicci.process.model.sofia.CpsStep;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.impl.LayoutContext;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class FeedbackSection
extends PropertySectionBase {
    private static final String[] templateNames = new String[]{"Custom", "LightValue-Template", "ProcessCompensation-Template"};
    private static final int GOAL_HEIGHT = 160;
    private static final int TEMPLATE_WIDTH_PERCENTAGE = 40;
    private CCombo cTemplate;
    private Text cGoal;
    private Text cContext;
    private SelectionListener selectionListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            int index = FeedbackSection.this.cTemplate.getSelectionIndex();
            if (index == 0) {
                return;
            }
            FeedbackSection.this.cGoal.setText(compensationData[index - 1]);
            FeedbackSection.this.writeToModel();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };
    private ModifyListener simpleModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            FeedbackSection.this.writeToModel();
        }
    };
    private static final String tLight = "{\n\t   \"name\":\"enough light for cooking2\",\n\t   \"objectives\":[\n\t      {  \n\t         \"name\":\"kitchen light intensity > 700 lux within two seconds\",\n\t         \"satisfiedExpression\":\"#lightIntensity > 700\",\n\t         \"compensateExpression\":\"#objective.created.isBefore(#now.minusSeconds(5))\",\n\t         \"testNodeIdExpression\":\"#stateId\",\n\t         \"contextExpressions\":[  \n\t            \"MATCH (thing)-[:type]->(sensor {name: 'LightSensor'})\",\n\t            \"MATCH (thing)-[:isIn]->(room {name: 'Kitchen_Mueller'})\",\n\t            \"MATCH (thing)-[:hasState]->(state:LightIntensityState)\",\n\t            \"MATCH (state)-[:hasStateValue]->(value)\",\n\t            \"WHERE toFloat(value.realStateValue) > 0\",\n\t            \"RETURN avg(toFloat(value.realStateValue)) AS lightIntensity, head(collect(id(state))) AS stateId\"\n\t         ]\n\t      }\n    ]\n}";
    private static final String tProcess = "{\n\t   \"name\":\"process executed\",\n\t   \"objectives\":[\n\t      {  \n\t         \"name\":\"process executed within 5 seconds\",\n\t         \"satisfiedExpression\":\"#state == 'executed'\",\n\t         \"compensateExpression\":\"#objective.created.isBefore(#now.minusSeconds(5))\",\n\t         \"testNodeIdExpression\":\"#state\",\n\t         \"contextExpressions\":[  \n             \"MATCH (n:NeoProcess {processId:'$piid'})\",\n             \"RETURN n.state AS state\"\n\t         ]\n\t      }\n    ]\n}";
    private static final String[] compensationData = new String[]{"{\n\t   \"name\":\"enough light for cooking2\",\n\t   \"objectives\":[\n\t      {  \n\t         \"name\":\"kitchen light intensity > 700 lux within two seconds\",\n\t         \"satisfiedExpression\":\"#lightIntensity > 700\",\n\t         \"compensateExpression\":\"#objective.created.isBefore(#now.minusSeconds(5))\",\n\t         \"testNodeIdExpression\":\"#stateId\",\n\t         \"contextExpressions\":[  \n\t            \"MATCH (thing)-[:type]->(sensor {name: 'LightSensor'})\",\n\t            \"MATCH (thing)-[:isIn]->(room {name: 'Kitchen_Mueller'})\",\n\t            \"MATCH (thing)-[:hasState]->(state:LightIntensityState)\",\n\t            \"MATCH (state)-[:hasStateValue]->(value)\",\n\t            \"WHERE toFloat(value.realStateValue) > 0\",\n\t            \"RETURN avg(toFloat(value.realStateValue)) AS lightIntensity, head(collect(id(state))) AS stateId\"\n\t         ]\n\t      }\n    ]\n}", "{\n\t   \"name\":\"process executed\",\n\t   \"objectives\":[\n\t      {  \n\t         \"name\":\"process executed within 5 seconds\",\n\t         \"satisfiedExpression\":\"#state == 'executed'\",\n\t         \"compensateExpression\":\"#objective.created.isBefore(#now.minusSeconds(5))\",\n\t         \"testNodeIdExpression\":\"#state\",\n\t         \"contextExpressions\":[  \n             \"MATCH (n:NeoProcess {processId:'$piid'})\",\n             \"RETURN n.state AS state\"\n\t         ]\n\t      }\n    ]\n}"};

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.createContext(composite);
        this.createTemplate(composite);
        this.createGoal(composite);
    }

    private void createTemplate(Composite parent) {
        this.cTemplate = this.getWidgetFactory().createCCombo(parent);
        this.cTemplate.setEditable(true);
        this.cTemplate.addSelectionListener(this.selectionListener);
        int i = 0;
        while (i < templateNames.length) {
            this.cTemplate.add(templateNames[i]);
            ++i;
        }
        FormData data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment(40, 0);
        data.top = new FormAttachment((Control)this.cContext, 4);
        this.cTemplate.setLayoutData((Object)data);
        CLabel valueLabel = this.getWidgetFactory().createCLabel(parent, "Templates(FBS):");
        FormData labelData = new FormData();
        labelData.left = new FormAttachment(0, 0);
        labelData.right = new FormAttachment((Control)this.cTemplate, -5);
        labelData.top = new FormAttachment((Control)this.cTemplate, 0, 0x1000000);
        valueLabel.setLayoutData((Object)labelData);
    }

    private void createGoal(Composite parent) {
        this.cGoal = this.getWidgetFactory().createText(parent, "", 578);
        this.cGoal.addModifyListener(this.simpleModifyListener);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.cTemplate, 4);
        data.bottom = new FormAttachment(0, 160);
        this.cGoal.setLayoutData((Object)data);
        CLabel valueLabel = this.getWidgetFactory().createCLabel(parent, "Goal(FBS):");
        FormData labelData = new FormData();
        labelData.left = new FormAttachment(0, 0);
        labelData.right = new FormAttachment((Control)this.cGoal, -5);
        labelData.top = new FormAttachment((Control)this.cGoal, 0, 0x1000000);
        valueLabel.setLayoutData((Object)labelData);
    }

    private void createContext(Composite parent) {
        this.cContext = this.getWidgetFactory().createText(parent, "", 4);
        this.cContext.addModifyListener(this.simpleModifyListener);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment(40, 0);
        data.top = new FormAttachment(0, 4);
        this.cContext.setLayoutData((Object)data);
        CLabel valueLabel = this.getWidgetFactory().createCLabel(parent, "Context(FBS)");
        FormData labelData = new FormData();
        labelData.left = new FormAttachment(0, 0);
        labelData.right = new FormAttachment((Control)this.cContext, -5);
        labelData.top = new FormAttachment((Control)this.cContext, 0, 0x1000000);
        valueLabel.setLayoutData((Object)labelData);
    }

    private CpsStep getCpsStepElement() {
        EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(this.getSelectedPictogramElement());
        if (bo != null) {
            return (CpsStep)bo;
        }
        return null;
    }

    public void refresh() {
        super.refresh();
        CpsStep processStep = this.getCpsStepElement();
        if (processStep == null) {
            return;
        }
        String sGoal = processStep.getGoal() == null ? "" : processStep.getGoal();
        String sContext = processStep.getContext() == null ? "" : processStep.getContext();
        this.cContext.removeModifyListener(this.simpleModifyListener);
        this.cGoal.removeModifyListener(this.simpleModifyListener);
        this.cContext.setText(sContext);
        this.cGoal.setText(sGoal);
        this.cContext.addModifyListener(this.simpleModifyListener);
        this.cGoal.addModifyListener(this.simpleModifyListener);
    }

    private void writeToModel() {
        final CpsStep processStep = this.getCpsStepElement();
        if (processStep == null) {
            return;
        }
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)processStep);
        editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){
            ProcessFeatureProvider featureProvider;
            {
                super($anonymous0);
                this.featureProvider = FeedbackSection.this.getProcessFeatureProvider();
            }

            protected void doExecute() {
                try {
                    processStep.setGoal(FeedbackSection.this.cGoal.getText());
                    processStep.setContext(FeedbackSection.this.cContext.getText());
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                this.featureProvider.layoutIfPossible((ILayoutContext)new LayoutContext(FeedbackSection.this.getSelectedPictogramElement()));
            }
        });
    }
}

