/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti.property;

import eu.vicci.process.graphiti.ProcessFeatureProvider;
import eu.vicci.process.graphiti.Util;
import eu.vicci.process.graphiti.property.PropertySectionBase;
import eu.vicci.process.model.sofia.ComplexType;
import eu.vicci.process.model.sofia.DataMapping;
import eu.vicci.process.model.sofia.DataPort;
import eu.vicci.process.model.sofia.DataType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.impl.LayoutContext;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class DataPortSection
extends PropertySectionBase {
    private Text valueText;
    private static CCombo dropdown;
    private List<DataType> dataTypes = new ArrayList<DataType>();
    private Composite composite;

    public void createControls(final Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory factory = this.getWidgetFactory();
        this.composite = factory.createFlatFormComposite(parent);
        this.valueText = factory.createText(this.composite, "");
        this.valueText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    new StateFocusListener().focusLost(null);
                }
            }
        });
        this.valueText.setEditable(true);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment(50, -5);
        data.top = new FormAttachment(0, 4);
        this.valueText.setLayoutData((Object)data);
        this.valueText.addFocusListener((FocusListener)new StateFocusListener());
        CLabel valueLabel = factory.createCLabel(this.composite, "Value:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.valueText, -5);
        data.top = new FormAttachment((Control)this.valueText, 0, 0x1000000);
        valueLabel.setLayoutData((Object)data);
        valueLabel.setVisible(true);
        dropdown = factory.createCCombo(this.composite);
        this.dataTypes = Util.getAllTypesAccessible(this.getSelectedPictogramElement());
        dropdown.removeAll();
        this.dataTypes.clear();
        for (DataType type : this.dataTypes) {
            dropdown.add(type.getName());
        }
        dropdown.addSelectionListener((SelectionListener)new MySelectionListener());
        data = new FormData();
        data.left = new FormAttachment(50, 85);
        data.right = new FormAttachment((Control)dropdown, 200);
        data.top = new FormAttachment(0, 4);
        dropdown.setLayoutData((Object)data);
        CLabel typeLabel = factory.createCLabel(this.composite, "DataType:");
        data = new FormData();
        data.top = new FormAttachment(0, 4);
        data.left = new FormAttachment((Control)this.valueText, 0);
        data.right = new FormAttachment((Control)dropdown, -5);
        typeLabel.setLayoutData((Object)data);
        this.composite.layout(true, true);
        dropdown.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(DataPortSection.this.getSelectedPictogramElement());
                if (bo instanceof DataPort) {
                    DataPortSection.this.clearMapping((DataPort)bo);
                    DataPortSection.this.createCheckboxes((DataPort)bo, parent);
                }
            }
        });
    }

    private void createCheckboxes(final DataPort dp, Composite parent) {
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof Composite) {
                if (((Composite)child).getToolTipText() != null && ((Composite)child).getToolTipText().equals("checkboxes")) {
                    child.dispose();
                    break;
                }
                ((Composite)child).layout(true, true);
            }
            ++n2;
        }
        if (dp.getPortDatatype() != null && dp.getPortDatatype().getMappings() != null && dp.getPortDatatype().getMappings().size() > 0) {
            boolean addedSomething = true;
            ArrayList<DataMapping> mappings = new ArrayList<DataMapping>();
            ArrayList mappingsHelper = new ArrayList();
            mappings.addAll((Collection<DataMapping>)dp.getPortDatatype().getMappings());
            if (dp.getPortDatatype() instanceof ComplexType) {
                ComplexType ct = (ComplexType)dp.getPortDatatype();
                ArrayList<DataType> types = new ArrayList<DataType>();
                types.addAll((Collection<DataType>)ct.getSubtypes());
                while (addedSomething) {
                    addedSomething = false;
                    for (DataType type : types) {
                        if (type.getMappings() != null && type.getMappings().size() > 0) {
                            mappingsHelper.addAll(type.getMappings());
                        }
                        if (!(type instanceof ComplexType) || types.contains(type)) continue;
                        types.add(type);
                        addedSomething = true;
                    }
                    for (DataMapping mapping : mappingsHelper) {
                        if (mappings.contains(mapping)) continue;
                        mappings.add(mapping);
                    }
                }
            }
            this.composite = new Composite(parent, 0);
            this.composite.setToolTipText("checkboxes");
            this.composite.setLayout((Layout)new FillLayout());
            CLabel typeLabel = new CLabel(this.composite, 0);
            typeLabel.setText("Mappings");
            for (final DataMapping mapping : mappings) {
                final Button b = new Button(this.composite, 32);
                b.setText(Util.shortenString(mapping.getName()));
                b.setToolTipText(mapping.getName());
                if (dp.getMappings().contains((Object)mapping)) {
                    b.setSelection(true);
                } else {
                    b.setSelection(false);
                }
                b.addFocusListener(new FocusListener(){

                    public void focusLost(FocusEvent e) {
                        if (b.getSelection()) {
                            DataPortSection.this.addOrRemoveMapping(true, dp, mapping);
                        } else {
                            DataPortSection.this.addOrRemoveMapping(false, dp, mapping);
                        }
                    }

                    public void focusGained(FocusEvent e) {
                    }
                });
            }
            this.composite.layout(true, true);
        }
        parent.layout(true, true);
    }

    public void refresh() {
        EObject bo;
        PictogramElement pe = this.getSelectedPictogramElement();
        if (pe != null && (bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe)) instanceof DataPort) {
            DataType type2;
            String value = ((DataPort)bo).getValue();
            this.valueText.setText(value == null ? "" : value);
            List<DataType> types = Util.getAllTypesAccessible(this.getSelectedPictogramElement());
            dropdown.removeAll();
            for (DataType type2 : types) {
                if (type2.getName() == null) continue;
                dropdown.add(type2.getName());
            }
            type2 = ((DataPort)bo).getPortDatatype();
            if (type2 != null && type2.getName() != null) {
                String typeName = type2.getName();
                dropdown.setText(typeName);
            }
            this.createCheckboxes((DataPort)bo, this.composite.getParent());
        }
    }

    private void addOrRemoveMapping(final boolean add, final DataPort port, final DataMapping mapping) {
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)port);
        editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){

            protected void doExecute() {
                if (add) {
                    port.getMappings().add((Object)mapping);
                } else {
                    port.getMappings().remove((Object)mapping);
                }
            }
        });
    }

    private void clearMapping(final DataPort port) {
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)port);
        editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){

            protected void doExecute() {
                port.getMappings().clear();
            }
        });
    }

    private class MySelectionListener
    implements SelectionListener {
        private MySelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            PictogramElement pe = DataPortSection.this.getSelectedPictogramElement();
            EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe);
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)bo);
            editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){

                protected void doExecute() {
                    PictogramElement pe = DataPortSection.this.getSelectedPictogramElement();
                    EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe);
                    List<DataType> accessibleTypes = Util.getAllTypesAccessible(pe);
                    if (bo instanceof DataPort) {
                        DataPort port = (DataPort)bo;
                        for (DataType type : accessibleTypes) {
                            if (!type.getName().equals(dropdown.getText())) continue;
                            port.setPortDatatype(type);
                            break;
                        }
                    }
                }
            });
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private class StateFocusListener
    implements FocusListener {
        private StateFocusListener() {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent event) {
            EObject bo;
            final PictogramElement pe = DataPortSection.this.getSelectedPictogramElement();
            if (pe != null && (bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe)) instanceof DataPort) {
                final DataPort dataPort = (DataPort)bo;
                TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((Object)bo);
                editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){
                    ProcessFeatureProvider featureProvider;
                    {
                        super($anonymous0);
                        this.featureProvider = DataPortSection.this.getProcessFeatureProvider();
                    }

                    protected void doExecute() {
                        String name = DataPortSection.this.valueText.getText();
                        if (name != null) {
                            dataPort.setValue(name);
                        }
                        this.featureProvider.layoutIfPossible((ILayoutContext)new LayoutContext(pe));
                        String typeName = dropdown.getText();
                        for (DataType type : DataPortSection.this.dataTypes) {
                            if (!type.getName().equals(typeName)) continue;
                            dataPort.setPortDatatype(type);
                        }
                        List<DataType> accessibleTypes = Util.getAllTypesAccessible(pe);
                        if (bo instanceof DataPort) {
                            DataPort port = (DataPort)bo;
                            for (DataType type : accessibleTypes) {
                                if (!type.getName().equals(dropdown.getText())) continue;
                                port.setPortDatatype(type);
                                break;
                            }
                        }
                    }
                });
            }
        }
    }
}

