/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti.property;

import eu.vicci.process.graphiti.AttributeMap;
import eu.vicci.process.graphiti.ProcessFeatureProvider;
import eu.vicci.process.graphiti.Util;
import eu.vicci.process.graphiti.property.PropertySectionBase;
import eu.vicci.process.model.sofia.Process;
import eu.vicci.process.model.sofia.ProcessStep;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.impl.LayoutContext;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class CpsSection
extends PropertySectionBase {
    private Button isCps;
    private Text controlId;
    private static CCombo cProcess;
    private List<Process> processes = new ArrayList<Process>();

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory factory = this.getWidgetFactory();
        Composite composite = factory.createFlatFormComposite(parent);
        this.isCps = factory.createButton(composite, "Cyber-Physical", 32);
        this.isCps.setEnabled(true);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this.isCps.setLayoutData((Object)data);
        this.isCps.addFocusListener((FocusListener)new StateFocusListener());
        composite = factory.createFlatFormComposite(parent);
        this.controlId = factory.createText(composite, "");
        this.controlId.setEditable(true);
        data = new FormData();
        data.left = new FormAttachment((Control)this.isCps, 85);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this.controlId.setLayoutData((Object)data);
        this.controlId.addFocusListener((FocusListener)new StateFocusListener());
        this.controlId.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    new StateFocusListener().focusLost(null);
                }
            }
        });
        CLabel valueLabel = factory.createCLabel(composite, "MapeProId:");
        data = new FormData();
        data.left = new FormAttachment((Control)this.isCps, 0);
        data.right = new FormAttachment((Control)this.controlId, -5);
        data.top = new FormAttachment((Control)this.controlId, 0, 0x1000000);
        valueLabel.setLayoutData((Object)data);
        composite = factory.createFlatFormComposite(parent);
        cProcess = factory.createCCombo(composite);
        this.processes = Util.getAllProcessesAccessible(this.getSelectedPictogramElement());
        cProcess.removeAll();
        this.processes.clear();
        for (Process p : this.processes) {
            cProcess.add(p.getName());
        }
        cProcess.addSelectionListener((SelectionListener)new MySelectionListener());
        data = new FormData();
        data.left = new FormAttachment((Control)this.controlId, 85);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        cProcess.setLayoutData((Object)data);
        CLabel mapeProcessLabel = factory.createCLabel(composite, "MapeProcess:");
        data = new FormData();
        data.left = new FormAttachment((Control)this.controlId, 0);
        data.right = new FormAttachment((Control)cProcess, -5);
        data.top = new FormAttachment((Control)cProcess, 0, 0x1000000);
        mapeProcessLabel.setLayoutData((Object)data);
        composite.layout(true, true);
        cProcess.addListener(13, new Listener(){

            public void handleEvent(Event event) {
            }
        });
    }

    public void refresh() {
        EObject bo;
        PictogramElement pe = this.getSelectedPictogramElement();
        if (pe != null && (bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe)) instanceof ProcessStep) {
            Process p2;
            ProcessStep ps = (ProcessStep)bo;
            boolean op = ps.isCyberPhysical();
            if (this.isCps.isDisposed() || this.controlId.isDisposed() || cProcess.isDisposed()) {
                return;
            }
            this.isCps.setSelection(op);
            this.controlId.setEnabled(true);
            cProcess.setEnabled(true);
            String cProcessId = ps.getControlProcessId();
            this.controlId.setText(cProcessId == null ? "" : cProcessId);
            List<Process> processes = Util.getAllProcessesAccessible(this.getSelectedPictogramElement());
            cProcess.removeAll();
            for (Process p2 : processes) {
                if (p2.getName() == null) continue;
                cProcess.add(p2.getName());
            }
            p2 = ((ProcessStep)bo).getControlProcess();
            if (p2 != null && p2.getName() != null) {
                String pName = p2.getName();
                cProcess.setText(pName);
            }
        }
    }

    private class MySelectionListener
    implements SelectionListener {
        private MySelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            PictogramElement pe = CpsSection.this.getSelectedPictogramElement();
            EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe);
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)bo);
            editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){

                protected void doExecute() {
                    PictogramElement pe = CpsSection.this.getSelectedPictogramElement();
                    EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe);
                    List<Process> accessibleProcesses = Util.getAllProcessesAccessible(pe);
                    if (bo instanceof ProcessStep) {
                        ProcessStep process = (ProcessStep)bo;
                        for (Process proc : accessibleProcesses) {
                            if (!proc.getName().equals(cProcess.getText())) continue;
                            process.setControlProcess(proc);
                            break;
                        }
                    }
                }
            });
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private class StateFocusListener
    implements FocusListener {
        private StateFocusListener() {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            final PictogramElement pe = CpsSection.this.getSelectedPictogramElement();
            if (pe != null) {
                final EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe);
                final Map<String, org.eclipse.graphiti.mm.algorithms.Text> map = AttributeMap.instance().getObjectMap(bo);
                if (bo instanceof ProcessStep) {
                    TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((Object)bo);
                    editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){
                        ProcessFeatureProvider featureProvider;
                        {
                            super($anonymous0);
                            this.featureProvider = CpsSection.this.getProcessFeatureProvider();
                        }

                        protected void doExecute() {
                            ProcessStep ps = (ProcessStep)bo;
                            boolean op = CpsSection.this.isCps.getSelection();
                            String cProcessId = CpsSection.this.controlId.getText();
                            ps.setCyberPhysical(op);
                            if (cProcessId != null) {
                                org.eclipse.graphiti.mm.algorithms.Text text;
                                ps.setControlProcessId(cProcessId);
                                if (map != null && (text = (org.eclipse.graphiti.mm.algorithms.Text)map.get("MapeProcess")) != null) {
                                    text.setValue("MapeProcess: " + cProcessId);
                                }
                            }
                            String processName = cProcess.getText();
                            for (Process p : CpsSection.this.processes) {
                                if (!p.getName().equals(processName)) continue;
                                ((ProcessStep)bo).setControlProcess(p);
                            }
                            List<Process> accessibleProcesses = Util.getAllProcessesAccessible(pe);
                            if (bo instanceof ProcessStep) {
                                ProcessStep p = (ProcessStep)bo;
                                for (Process proc : accessibleProcesses) {
                                    if (!proc.getName().equals(cProcess.getText())) continue;
                                    p.setControlProcess(proc);
                                }
                            }
                            this.featureProvider.layoutIfPossible((ILayoutContext)new LayoutContext(pe));
                        }
                    });
                }
            }
        }
    }
}

