/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti.property;

import eu.vicci.process.graphiti.AttributeMap;
import eu.vicci.process.graphiti.ProcessFeatureProvider;
import eu.vicci.process.graphiti.Util;
import eu.vicci.process.graphiti.property.PropertySectionBase;
import eu.vicci.process.model.sofia.Comparator;
import eu.vicci.process.model.sofia.Condition;
import eu.vicci.process.model.sofia.If;
import eu.vicci.process.model.sofia.Loop;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.impl.LayoutContext;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class ConditionSection
extends PropertySectionBase {
    private CCombo comparatorBox;

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory factory = this.getWidgetFactory();
        Composite composite = factory.createFlatFormComposite(parent);
        this.comparatorBox = factory.createCCombo(composite);
        List list = Comparator.VALUES;
        for (Comparator c : list) {
            this.comparatorBox.add(c.getName());
        }
        FormData data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this.comparatorBox.setLayoutData((Object)data);
        this.comparatorBox.addFocusListener((FocusListener)new StateFocusListener());
        this.comparatorBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                new StateFocusListener().focusLost(null);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                new StateFocusListener().focusLost(null);
            }
        });
        CLabel valueLabel = factory.createCLabel(composite, "Condition:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.comparatorBox, -5);
        data.top = new FormAttachment((Control)this.comparatorBox, 0, 0x1000000);
        valueLabel.setLayoutData((Object)data);
    }

    public void refresh() {
        PictogramElement pe = this.getSelectedPictogramElement();
        if (pe != null) {
            Condition cond;
            EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe);
            if (bo instanceof Loop && (cond = ((Loop)bo).getLoopCondition()) != null) {
                this.comparatorBox.select(cond.getComparator().getValue());
            }
            if (bo instanceof If && (cond = ((If)bo).getIfCondition()) != null) {
                this.comparatorBox.select(cond.getComparator().getValue());
            }
        }
    }

    private class StateFocusListener
    implements FocusListener {
        private StateFocusListener() {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            final PictogramElement pe = ConditionSection.this.getSelectedPictogramElement();
            if (pe != null) {
                final EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe);
                final Map<String, Text> map = AttributeMap.instance().getObjectMap(bo);
                if (bo instanceof Loop) {
                    TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((Object)bo);
                    editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){
                        ProcessFeatureProvider featureProvider;
                        {
                            super($anonymous0);
                            this.featureProvider = ConditionSection.this.getProcessFeatureProvider();
                        }

                        protected void doExecute() {
                            Text text;
                            Condition cond = ((Loop)bo).getLoopCondition();
                            if (cond != null) {
                                cond.setComparator(Comparator.get((String)ConditionSection.this.comparatorBox.getText()));
                            }
                            if (map != null && cond != null && (text = (Text)map.get("condition")) != null) {
                                text.setValue(cond.getComparator().getName());
                            }
                            this.featureProvider.layoutIfPossible((ILayoutContext)new LayoutContext(pe));
                        }
                    });
                } else if (bo instanceof If) {
                    TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((Object)bo);
                    editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){
                        ProcessFeatureProvider featureProvider;
                        {
                            super($anonymous0);
                            this.featureProvider = ConditionSection.this.getProcessFeatureProvider();
                        }

                        protected void doExecute() {
                            Text text;
                            Condition cond = ((If)bo).getIfCondition();
                            if (cond != null) {
                                cond.setComparator(Comparator.get((String)ConditionSection.this.comparatorBox.getText()));
                            }
                            if (map != null && cond != null && (text = (Text)map.get("condition")) != null) {
                                text.setValue(Util.getOperator(cond.getComparator()));
                            }
                            this.featureProvider.layoutIfPossible((ILayoutContext)new LayoutContext(pe));
                        }
                    });
                }
            }
        }
    }
}

