/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti.feature.resize;

import eu.vicci.process.graphiti.Util;
import eu.vicci.process.model.sofia.And;
import eu.vicci.process.model.sofia.EndPort;
import eu.vicci.process.model.sofia.If;
import eu.vicci.process.model.sofia.Or;
import eu.vicci.process.model.sofia.Process;
import eu.vicci.process.model.sofia.ProcessStep;
import eu.vicci.process.model.sofia.StartPort;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IResizeConfiguration;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.impl.DefaultResizeShapeFeature;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.RoundedRectangle;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;

public class PictogramResizeShapeFeature
extends DefaultResizeShapeFeature {
    public PictogramResizeShapeFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canResizeShape(IResizeShapeContext context) {
        if (!super.canResizeShape(context)) {
            return false;
        }
        Shape shape = context.getShape();
        Object object = this.getBusinessObjectForPictogramElement((PictogramElement)shape);
        return object instanceof If || object instanceof And || object instanceof Or;
    }

    void resize(Shape shape, int width, int height, Object object) {
        block7: {
            GraphicsAlgorithm ga;
            block5: {
                Object shapeObject;
                block8: {
                    block6: {
                        shapeObject = this.getBusinessObjectForPictogramElement((PictogramElement)shape);
                        ga = shape.getGraphicsAlgorithm();
                        if (shape instanceof ContainerShape && object.equals(shapeObject)) {
                            for (Shape s : ((ContainerShape)shape).getChildren()) {
                                this.resize(s, width, height, object);
                            }
                        }
                        if (ga instanceof Text) {
                            ((Text)ga).setWidth(width);
                            ((Text)ga).setHeight(height);
                        }
                        if (!(ga instanceof Rectangle) && !(ga instanceof RoundedRectangle)) break block5;
                        if (!object.equals(shapeObject) || !(shapeObject instanceof Process) && !(shapeObject instanceof ProcessStep)) break block6;
                        ((Rectangle)ga).setWidth(width);
                        break block7;
                    }
                    if (!(shapeObject instanceof StartPort)) break block8;
                    ((RoundedRectangle)ga).setX(0);
                    break block7;
                }
                if (!(shapeObject instanceof EndPort)) break block7;
                ((RoundedRectangle)ga).setX(width - ((RoundedRectangle)ga).getWidth());
                break block7;
            }
            if (ga instanceof Polyline) {
                Polyline poly = (Polyline)ga;
                float scaleX = (float)shape.getGraphicsAlgorithm().getWidth() / (float)width;
                float scaleY = (float)shape.getGraphicsAlgorithm().getHeight() / (float)height;
                int i = 0;
                while (i < poly.getPoints().size()) {
                    int preX = ((Point)poly.getPoints().get(i)).getX();
                    int preY = ((Point)poly.getPoints().get(i)).getY();
                    ((Point)poly.getPoints().get(i)).setX((int)((float)preX * scaleX));
                    ((Point)poly.getPoints().get(i)).setY((int)((float)preY * scaleY));
                    ++i;
                }
            }
        }
    }

    public IResizeConfiguration getResizeConfiguration(IResizeShapeContext context) {
        IResizeConfiguration config = new IResizeConfiguration(){

            public boolean isVerticalResizeAllowed() {
                return true;
            }

            public boolean isHorizontalResizeAllowed() {
                return false;
            }
        };
        return config;
    }

    public void resizeShape(IResizeShapeContext context) {
        Object object = this.getBusinessObjectForPictogramElement((PictogramElement)context.getShape());
        Shape container = context.getShape();
        int preWidth = container.getGraphicsAlgorithm().getWidth();
        int preHeight = container.getGraphicsAlgorithm().getHeight();
        super.resizeShape(context);
        if (container instanceof ContainerShape && (object instanceof If || object instanceof Or || object instanceof And)) {
            Util.resizeAndIfOr((ContainerShape)container, preHeight, context.getHeight());
        } else {
            this.resize(container, preWidth, preHeight, object);
        }
    }
}

