/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti.feature;

import eu.vicci.process.graphiti.AttributeMap;
import eu.vicci.process.graphiti.Util;
import eu.vicci.process.model.sofia.Invoke;
import eu.vicci.process.model.sofia.ProcessStep;
import eu.vicci.process.model.sofia.Transition;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class RenameTaskFeature
extends AbstractCustomFeature {
    private boolean hasDoneChanges = false;

    public RenameTaskFeature(IFeatureProvider fp) {
        super(fp);
    }

    public String getName() {
        return "Re&name Task";
    }

    public String getDescription() {
        return "Change the name of the Task";
    }

    public boolean canExecute(ICustomContext context) {
        boolean ret = false;
        PictogramElement[] pes = context.getPictogramElements();
        if (pes != null && pes.length == 1) {
            Object object = this.getBusinessObjectForPictogramElement(pes[0]);
            if (object instanceof Invoke) {
                ret = true;
            }
            if (object instanceof Transition) {
                ret = true;
            }
        }
        return ret;
    }

    public void execute(ICustomContext context) {
        PictogramElement[] pes = context.getPictogramElements();
        if (pes != null && pes.length == 1) {
            String currentName;
            Object object = this.getBusinessObjectForPictogramElement(pes[0]);
            if (object instanceof ProcessStep) {
                ProcessStep invoke = (ProcessStep)object;
                currentName = invoke.getName();
                Map<String, Text> map = AttributeMap.instance().getObjectMap(object);
                String newName = Util.askString("Rename Task", this.getDescription(), currentName);
                if (newName != null && !newName.equals(currentName)) {
                    Text text;
                    this.hasDoneChanges = true;
                    invoke.setName(newName);
                    this.updatePictogramElement(pes[0]);
                    if (map != null && (text = map.get("name")) != null) {
                        text.setValue("name: " + newName);
                    }
                }
            }
            if (object instanceof Transition) {
                Transition trans = (Transition)object;
                currentName = trans.getName();
                String newName = Util.askString("Rename Task", this.getDescription(), currentName);
                if (newName != null && !newName.equals(currentName)) {
                    this.hasDoneChanges = true;
                    trans.setName(newName);
                    Util.redrawConnectionDecorator((EObject)trans, this.getDiagram());
                    this.updatePictogramElement(pes[0]);
                }
            }
        }
    }

    public boolean hasDoneChanges() {
        return this.hasDoneChanges;
    }
}

