/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti.execution.ui;

import eu.vicci.process.graphiti.execution.debug.model.ProcessDebugTarget;
import eu.vicci.process.graphiti.execution.debug.model.ProcessThread;
import eu.vicci.process.graphiti.feature.ProcessClickedFeature;
import java.util.Arrays;
import java.util.Optional;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;
import org.eclipse.graphiti.ui.editor.IDiagramContainerUI;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class ExecuteProcessDiagramBehavior
extends DiagramBehavior {
    private String instanceId;

    public ExecuteProcessDiagramBehavior(IDiagramContainerUI diagramContainer) {
        super(diagramContainer);
    }

    public Object executeFeature(IFeature feature, IContext context) {
        if (!(feature instanceof ProcessClickedFeature)) {
            return super.executeFeature(feature, context);
        }
        this.onProcessClicked(((ProcessClickedFeature)feature).getProcessId());
        return null;
    }

    private void onProcessClicked(String processId) {
        if (this.instanceId == null || processId == null) {
            return;
        }
        System.out.println("Clicked on process " + processId + " for instance " + this.instanceId);
        try {
            AbstractDebugView debugViewPart = (AbstractDebugView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.debug.ui.DebugView");
            TreeViewer treeViewer = (TreeViewer)debugViewPart.getViewer();
            ILaunch launch = this.getLaunch(treeViewer);
            if (launch == null) {
                return;
            }
            ProcessDebugTarget target = (ProcessDebugTarget)launch.getDebugTarget();
            if (target == null) {
                return;
            }
            ProcessThread pt = this.getProcessThread(target, processId);
            if (pt == null) {
                return;
            }
            TreePath path = new TreePath(new Object[]{launch, target, pt});
            StructuredSelection selection = new StructuredSelection(new Object[]{pt.getTopStackFrame()});
            this.dispatchSelection(treeViewer, path, (IStructuredSelection)selection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void dispatchSelection(final TreeViewer viewer, final TreePath path, final IStructuredSelection selection) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                viewer.expandToLevel((Object)path, 1);
                viewer.setSelection((ISelection)selection, true);
            }
        });
    }

    private ILaunch getLaunch(TreeViewer viewer) {
        Object input = viewer.getInput();
        if (!(input instanceof ILaunchManager)) {
            return null;
        }
        ILaunchManager lm = (ILaunchManager)input;
        ILaunch[] iLaunchArray = lm.getLaunches();
        int n = iLaunchArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            if (this.checkTarget(launch.getDebugTargets())) {
                return launch;
            }
            ++n2;
        }
        return null;
    }

    private boolean checkTarget(IDebugTarget[] targets) {
        IDebugTarget[] iDebugTargetArray = targets;
        int n = targets.length;
        int n2 = 0;
        while (n2 < n) {
            IDebugTarget target = iDebugTargetArray[n2];
            if (!(target instanceof ProcessDebugTarget)) {
                return false;
            }
            if (((ProcessDebugTarget)target).getInstanceId().equals(this.instanceId)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private ProcessThread getProcessThread(ProcessDebugTarget target, String processId) throws DebugException {
        Optional<ProcessThread> pt = Arrays.asList(target.getThreads()).stream().filter(t -> processId.equals(t.getVicciProcessId())).findFirst();
        if (pt.isPresent()) {
            return pt.get();
        }
        return null;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public boolean isInstanceEditor() {
        return this.instanceId != null;
    }
}

