/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti.execution.launch;

import eu.vicci.process.adapter.util.AdapterUtil;
import eu.vicci.process.adapter.wizard.StartValuesWizard;
import eu.vicci.process.client.core.IProcessEngineClient;
import eu.vicci.process.graphiti.execution.debug.ProcessDebugger;
import eu.vicci.process.graphiti.execution.debug.dispatcher.EventDispatchJob;
import eu.vicci.process.graphiti.execution.debug.model.ProcessDebugTarget;
import eu.vicci.process.graphiti.execution.interpreter.ProcessInterpreter;
import eu.vicci.process.graphiti.execution.interpreter.ProcessInterpreterConfig;
import eu.vicci.process.graphiti.execution.ui.ExecuteProcessEditor;
import eu.vicci.process.graphiti.execution.ui.ExecuteProcessEditorInput;
import eu.vicci.process.model.sofiainstance.DataTypeInstance;
import eu.vicci.process.model.sofiainstance.ProcessInstance;
import eu.vicci.process.model.sofiainstance.StartDataPortInstance;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate2;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteProcessConfigurationType
implements ILaunchConfigurationDelegate2 {
    private static final Logger logger = LoggerFactory.getLogger(ExecuteProcessConfigurationType.class);
    private static final String CLIENT_SUFFIX = "_Launcher";
    private IProcessEngineClient client;
    private ProcessInterpreterConfig config;
    private Map<String, DataTypeInstance> startParameter;
    private ProcessInstance processInstance;
    public static final String ID = "eu.vicci.process.graphiti.execution.launch.executeProcessConfigurationType";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        logger.debug("launched vicci process execution");
        ExecuteProcessEditor editor = ExecuteProcessConfigurationType.openEditor(this.config.getFile());
        ExecuteProcessConfigurationType.checkEditor(editor);
        editor.setInstanceId(this.processInstance.getInstanceId());
        ProcessInterpreter interpreter = new ProcessInterpreter(editor, this.processInstance);
        this.debug(interpreter, editor, launch, this.config.getFile());
    }

    private void debug(ProcessInterpreter interpreter, ExecuteProcessEditor editor, ILaunch launch, IFile file) {
        ProcessDebugTarget debugTarget = new ProcessDebugTarget(launch, file, this.processInstance.getInstanceId());
        ProcessDebugger debugger = new ProcessDebugger(interpreter);
        interpreter.setDebugger(debugger);
        EventDispatchJob dispatcher = new EventDispatchJob(debugTarget, debugger);
        dispatcher.schedule();
        debugger.setEventDispatcher(dispatcher);
        debugTarget.setEventDispatcher(dispatcher);
        launch.addDebugTarget((IDebugTarget)debugTarget);
        interpreter.init();
        interpreter.schedule();
        this.client.startProcessInstance(this.processInstance.getInstanceId(), this.startParameter);
        this.client.close();
    }

    private String uploadAndDeploy(IProcessEngineClient client, String modelPath) throws DebugException {
        String id = client.uploadModelFile(modelPath, true);
        if (id == null) {
            this.throwDebugException("model upload / deployment or start instance failed");
        }
        if ((id = client.deployProcess(id)) == null) {
            this.throwDebugException("model upload / deployment or start instance failed");
        }
        if ((id = client.deployProcessInstance(id)) == null) {
            this.throwDebugException("model upload / deployment or start instance failed");
        }
        return id;
    }

    private void throwDebugException(String text) throws DebugException {
        throw new DebugException((IStatus)new Status(4, "eu.vicci.process.graphiti.execution", text));
    }

    private void checkClient(IProcessEngineClient client) throws DebugException {
        if (!client.connect()) {
            logger.error("failed to connect");
            client.close();
            this.throwDebugException("Cant connect to process engine");
        }
    }

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        logger.debug("get ILaunch");
        return null;
    }

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        logger.debug("build for launch");
        return false;
    }

    public boolean finalLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        logger.debug("final launch check");
        this.config = new ProcessInterpreterConfig(configuration);
        this.config.checkConfigValues(logger);
        this.client = AdapterUtil.createClient((String)CLIENT_SUFFIX);
        this.checkClient(this.client);
        String path = this.config.getFile().getFullPath().toString();
        String instanceId = this.uploadAndDeploy(this.client, path);
        this.processInstance = this.client.getProcessInstanceInfos(instanceId);
        this.checkProcessInstance();
        List<DataTypeInstance> dtis = this.getDataTypeInstances(this.processInstance);
        if (!dtis.isEmpty()) {
            Shell shell = Display.getDefault().getActiveShell();
            this.startParameter = this.createStartData(dtis, shell);
        }
        monitor.worked(1);
        monitor.done();
        return true;
    }

    private void checkProcessInstance() throws DebugException {
        if (this.processInstance == null || this.processInstance.getInstanceId() == null || this.processInstance.getProcessModelID() == null) {
            this.throwDebugException("receiving the process instance failed");
        }
    }

    private Map<String, DataTypeInstance> createStartData(List<DataTypeInstance> dataTypeInstances, Shell shell) {
        StartValuesWizard wizard = new StartValuesWizard(dataTypeInstances);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        if (dialog.open() == 0) {
            return wizard.getStartValues();
        }
        return null;
    }

    private List<DataTypeInstance> getDataTypeInstances(ProcessInstance instance) {
        return instance.getPorts().stream().filter(p -> p instanceof StartDataPortInstance).map(p -> ((StartDataPortInstance)p).getDataInstance()).collect(Collectors.toList());
    }

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        logger.debug("preLaunchCheck");
        return true;
    }

    private static ExecuteProcessEditor openEditor(IFile fileToOpen) {
        OpenEditor open = new OpenEditor(fileToOpen);
        Display.getDefault().syncExec((Runnable)open);
        return open.editor;
    }

    private static void checkEditor(ExecuteProcessEditor editor) throws DebugException {
        if (editor != null) {
            return;
        }
        logger.error("error while opening the process execution editor");
        throw new DebugException((IStatus)new Status(4, "eu.vicci.process.graphiti.execution", "error while opening the process execution editor"));
    }

    private static class OpenEditor
    implements Runnable {
        ExecuteProcessEditor editor = null;
        IFile fileToOpen;

        public OpenEditor(IFile fileToOpen) {
            this.fileToOpen = fileToOpen;
        }

        @Override
        public void run() {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IPath path = this.fileToOpen.getFullPath();
            URI uri = URI.createPlatformResourceURI((String)path.toString(), (boolean)true);
            ExecuteProcessEditorInput input = new ExecuteProcessEditorInput(uri);
            try {
                this.editor = (ExecuteProcessEditor)page.openEditor((IEditorInput)input, "eu.vicci.process.graphiti.execution.executeProcessEditor");
            }
            catch (PartInitException partInitException) {}
        }
    }
}

