/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti.execution.interpreter;

import eu.vicci.process.adapter.util.AdapterUtil;
import eu.vicci.process.client.core.IProcessEngineClient;
import eu.vicci.process.graphiti.execution.debug.ProcessDebugger;
import eu.vicci.process.graphiti.execution.interpreter.AbstractProcessInterpreter;
import eu.vicci.process.graphiti.execution.ui.ExecuteProcessEditor;
import eu.vicci.process.model.sofiainstance.ProcessInstance;
import eu.vicci.process.model.sofiainstance.State;
import eu.vicci.process.model.util.messages.core.IStateChangeMessage;
import eu.vicci.process.model.util.messages.core.StateChangeListener;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.swt.widgets.Display;

public class ProcessInterpreter
extends AbstractProcessInterpreter
implements ExecuteProcessEditor.DisposeListener {
    private static final String CLIENT_SUFFIX = "_Interpreter";
    private ProcessDebugger debugger;
    private final ProcessInstance rootProcess;
    private boolean isCanceled = false;
    private CountDownLatch waitTillFinished;
    private IProcessEngineClient client;
    private ArrayBlockingQueue<Object> messages = new ArrayBlockingQueue(1000);
    private StateChangeListener stateChangeListener = new StateChangeListener(){

        public void onMessage(IStateChangeMessage message) {
            ProcessInterpreter.this.messages.add(message);
            if (ProcessInterpreter.this.rootProcess.getInstanceId().equals(message.getInstanceId()) && ProcessInterpreter.this.stateFinished(message.getState())) {
                ProcessInterpreter.this.messages.add(new Object());
            }
        }
    };

    public ProcessInterpreter(ExecuteProcessEditor editor, ProcessInstance rootProcess) {
        super(editor);
        this.rootProcess = rootProcess;
    }

    @Override
    public void init() {
        super.init();
        this.editor.setDisposeListener(this);
    }

    public void setDebugger(ProcessDebugger debugger) {
        this.debugger = debugger;
    }

    protected void canceling() {
        this.cancelRun();
        super.canceling();
    }

    protected IStatus run(IProgressMonitor monitor) {
        logger.debug("running process runner for {}", (Object)this.rootProcess.getInstanceId());
        this.waitTillFinished = new CountDownLatch(1);
        this.client = AdapterUtil.createClient((String)CLIENT_SUFFIX);
        if (!this.client.connect()) {
            logger.error("Cant connect to process engine " + this.client.getIp() + ":" + this.client.getPort());
            return Status.CANCEL_STATUS;
        }
        this.debuggerLoaded();
        this.registerClientAndInitialStates();
        this.startStateMessageConsumer();
        this.waitTillFinishedOrCanceled();
        this.closeClient();
        this.debuggerTerminated();
        logger.debug("runner finished for {}", (Object)this.rootProcess.getInstanceId());
        if (this.isCanceled) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    private void startStateMessageConsumer() {
        Thread stateMessageConsumer = new Thread(() -> {
            while (true) {
                try {
                    Object out;
                    while ((out = this.messages.take()) instanceof IStateChangeMessage) {
                        this.handleStateMessage((IStateChangeMessage)out);
                    }
                    this.waitTillFinished.countDown();
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        });
        stateMessageConsumer.setName("StateMessageQueue");
        stateMessageConsumer.setDaemon(true);
        stateMessageConsumer.start();
    }

    private void closeClient() {
        this.client.removeStateChangeListener(this.stateChangeListener);
        this.client.close();
    }

    private void waitTillFinishedOrCanceled() {
        try {
            this.waitTillFinished.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void debuggerLoaded() {
        if (this.debugger != null) {
            this.debugger.loaded();
        }
    }

    private void debuggerTerminated() {
        if (this.debugger != null) {
            this.debugger.terminated();
        }
    }

    private void registerClientAndInitialStates() {
        this.client.addStateChangeListener(this.stateChangeListener);
        List changes = this.client.getInstanceLog(this.rootProcess.getInstanceId());
        changes.stream().forEach(m -> this.handleStateMessage((IStateChangeMessage)m));
        logger.debug("initial states handled");
    }

    private boolean stateFinished(State state) {
        return state == State.DEACTIVATED || state == State.FAILED || state == State.EXECUTED || state == State.STOPPED || state == State.KILLED;
    }

    private synchronized void handleStateMessage(IStateChangeMessage message) {
        Shape shape;
        if (this.isCanceled) {
            return;
        }
        if (this.debugger != null) {
            this.debugger.processStateChanged(message);
        }
        if ((shape = (Shape)this.objectsMap.get(message.getProcessId())) == null) {
            return;
        }
        Display.getDefault().asyncExec(() -> this.changeBorderColor(shape, this.getStateColor(message.getState())));
    }

    public void terminate() {
        this.cancelRun();
    }

    private void cancelRun() {
        this.isCanceled = true;
        this.messages.add(new Object());
    }

    @Override
    public void onDispose() {
        this.cancelRun();
    }
}

