/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti.execution.interpreter;

import eu.vicci.process.graphiti.execution.ui.ExecuteProcessEditor;
import eu.vicci.process.model.sofia.Identifiable;
import eu.vicci.process.model.sofia.Process;
import eu.vicci.process.model.sofiainstance.State;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.styles.AbstractStyle;
import org.eclipse.graphiti.mm.algorithms.styles.Color;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.util.IColorConstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProcessInterpreter
extends Job {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractProcessInterpreter.class);
    private static final String name = "Process Runner";
    protected final ExecuteProcessEditor editor;
    private final Map<IColorConstant, Color> colors = new HashMap<IColorConstant, Color>();
    protected Map<String, Shape> objectsMap = Collections.synchronizedMap(new HashMap());
    private Process process;

    public AbstractProcessInterpreter(ExecuteProcessEditor editor) {
        super(name);
        this.editor = editor;
    }

    public void init() {
        logger.debug("initializing process runner");
        this.setColors();
        this.process = this.getEditorProcess();
        this.createMapping();
    }

    protected void changeBorderColor(final Shape shape, final Color color) {
        CommandStack stack = this.editor.getEditingDomain().getCommandStack();
        stack.execute((Command)new RecordingCommand(this.editor.getEditingDomain()){

            protected void doExecute() {
                GraphicsAlgorithm ga = shape.getGraphicsAlgorithm();
                if (ga instanceof AbstractStyle) {
                    ga.setForeground(color);
                }
            }
        });
    }

    protected Color getStateColor(State state) {
        switch (state) {
            case INACTIVE: {
                return this.colors.get(IColorConstant.BLACK);
            }
            case EXECUTING: {
                return this.colors.get(IColorConstant.YELLOW);
            }
            case ACTIVE: {
                return this.colors.get(IColorConstant.BLUE);
            }
            case EXECUTED: {
                return this.colors.get(IColorConstant.GREEN);
            }
            case DEACTIVATED: {
                return this.colors.get(IColorConstant.ORANGE);
            }
        }
        return this.colors.get(IColorConstant.RED);
    }

    protected Diagram getDiagram() {
        return this.editor.getDiagramTypeProvider().getDiagram();
    }

    private void setColor(final IColorConstant colorConstant) {
        CommandStack stack = this.editor.getEditingDomain().getCommandStack();
        stack.execute((Command)new RecordingCommand(this.editor.getEditingDomain()){

            protected void doExecute() {
                Color color = Graphiti.getGaService().manageColor(AbstractProcessInterpreter.this.getDiagram(), colorConstant);
                AbstractProcessInterpreter.this.colors.put(colorConstant, color);
            }
        });
    }

    private void setColors() {
        this.setColor(IColorConstant.BLACK);
        this.setColor(IColorConstant.YELLOW);
        this.setColor(IColorConstant.BLUE);
        this.setColor(IColorConstant.GREEN);
        this.setColor(IColorConstant.ORANGE);
        this.setColor(IColorConstant.RED);
    }

    private void createMapping() {
        Diagram diagram = this.editor.getDiagramTypeProvider().getDiagram();
        EList shapes = diagram.getChildren();
        if (shapes.size() != 1) {
            logger.error("The root process was not found. Process models should always have a root process, which contains all other processes");
            return;
        }
        this.addShapeContentToMap((Shape)shapes.get(0));
    }

    private void addShapeContentToMap(Shape shape) {
        if (shape instanceof ContainerShape) {
            for (Shape child : ((ContainerShape)shape).getChildren()) {
                this.addShapeContentToMap(child);
            }
        }
        PictogramElement element = shape.getLink().getPictogramElement();
        EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(element);
        if (bo == null) {
            logger.error("can not get the business object for '{}'", (Object)shape.toString());
        }
        String uid = null;
        if (bo instanceof Identifiable) {
            uid = ((Identifiable)bo).getId();
        } else {
            logger.warn("'{}' is no Identifiable", (Object)bo.toString());
        }
        if (uid != null) {
            this.objectsMap.put(uid, shape);
        }
    }

    private Process getEditorProcess() {
        EList children = this.getDiagram().getChildren();
        Process process = (Process)Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement((PictogramElement)children.get(0));
        return process;
    }

    public Process getVicciProcess() {
        return this.process;
    }
}

