/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti.execution.debug.model;

import eu.vicci.process.graphiti.execution.debug.dispatcher.EventDispatchJob;
import eu.vicci.process.graphiti.execution.debug.dispatcher.IEventProcessor;
import eu.vicci.process.graphiti.execution.debug.events.DebuggerStartedEvent;
import eu.vicci.process.graphiti.execution.debug.events.IDebugEvent;
import eu.vicci.process.graphiti.execution.debug.events.ResumeEvent;
import eu.vicci.process.graphiti.execution.debug.events.StateChangedEvent;
import eu.vicci.process.graphiti.execution.debug.events.TerminateEvent;
import eu.vicci.process.graphiti.execution.debug.events.TerminatedEvent;
import eu.vicci.process.graphiti.execution.debug.model.ProcessDebugProcess;
import eu.vicci.process.graphiti.execution.debug.model.ProcessThread;
import eu.vicci.process.graphiti.execution.debug.model.variables.AbstractProcessVariable;
import eu.vicci.process.graphiti.execution.debug.model.variables.PortListValue;
import eu.vicci.process.graphiti.execution.debug.model.variables.PortListVariable;
import eu.vicci.process.graphiti.execution.debug.model.variables.PortValue;
import eu.vicci.process.graphiti.execution.debug.model.variables.PortVariable;
import eu.vicci.process.graphiti.execution.debug.model.variables.StateVariable;
import eu.vicci.process.graphiti.execution.debug.model.variables.StringVariable;
import eu.vicci.process.model.util.messages.core.IStateChangeMessage;
import eu.vicci.process.model.util.serialization.jsonprocessstepinstances.core.IJSONDataPortInstance;
import eu.vicci.process.model.util.serialization.jsonprocessstepinstances.core.IJSONPortInstance;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.DebugElement;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessDebugTarget
extends DebugElement
implements IDebugTarget,
IEventProcessor {
    private static final Logger logger = LoggerFactory.getLogger(ProcessDebugTarget.class);
    private final String name;
    private final ILaunch launch;
    private final IFile file;
    private final ProcessDebugProcess process;
    private final String instanceId;
    private final List<ProcessThread> threads = new ArrayList<ProcessThread>();
    private EventDispatchJob dispatcher;
    private DebugTargetState state = DebugTargetState.NOT_STARTED;

    public ProcessDebugTarget(ILaunch launch, IFile file, String instanceId) {
        super(null);
        this.launch = launch;
        this.file = file;
        this.instanceId = instanceId;
        if (instanceId == null) {
            throw new IllegalArgumentException("the instanceId cant be null for this debug target");
        }
        this.name = file.getName();
        this.fireCreationEvent();
        this.process = new ProcessDebugProcess(this);
        this.process.fireCreationEvent();
    }

    public String getModelIdentifier() {
        return null;
    }

    public boolean canTerminate() {
        return !this.isTerminated() && !this.isDisconnected();
    }

    public boolean isTerminated() {
        return this.state == DebugTargetState.TERMINATED;
    }

    public void terminate() throws DebugException {
        this.fireModelEvent(new TerminateEvent());
    }

    public boolean canResume() {
        return this.isSuspended();
    }

    public boolean canSuspend() {
        return false;
    }

    public boolean isSuspended() {
        return this.state == DebugTargetState.SUSPENDED;
    }

    public void resume() throws DebugException {
        this.fireModelEvent(new ResumeEvent());
    }

    public void suspend() throws DebugException {
        throw new DebugException((IStatus)new Status(4, "eu.vicci.process.execution.debug", "suspend() not supported"));
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public boolean canDisconnect() {
        return false;
    }

    public void disconnect() throws DebugException {
        throw new DebugException((IStatus)new Status(4, "eu.vicci.process.execution.debug", "disconnect() not supported"));
    }

    public boolean isDisconnected() {
        return false;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return null;
    }

    public IFile getFile() {
        return this.file;
    }

    public IProcess getProcess() {
        return this.process;
    }

    public ProcessThread[] getThreads() throws DebugException {
        return this.threads.toArray(new ProcessThread[this.threads.size()]);
    }

    public boolean hasThreads() throws DebugException {
        return !this.threads.isEmpty();
    }

    public String getName() throws DebugException {
        return this.name;
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return this.instanceId.equals(breakpoint.getModelIdentifier());
    }

    @Override
    public void handleEvent(IDebugEvent event) {
        if (event instanceof StateChangedEvent) {
            this.handleStateChanged((StateChangedEvent)event);
        } else if (event instanceof TerminatedEvent) {
            this.handleTerminated();
        } else if (event instanceof DebuggerStartedEvent) {
            this.handleStartedEvent((DebuggerStartedEvent)event);
        }
    }

    public ProcessDebugTarget getDebugTarget() {
        return this;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public void setEventDispatcher(EventDispatchJob dispatcher) {
        this.dispatcher = dispatcher;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    private void fireModelEvent(IDebugEvent event) {
        this.dispatcher.addEvent(event);
    }

    private void handleStartedEvent(DebuggerStartedEvent event) {
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointListener)this);
    }

    private void handleStateChanged(StateChangedEvent event) {
        try {
            String id = event.getMessage().getProcessId();
            String name = event.getMessage().getProcessName();
            ProcessThread t = this.addThreadIfNotExists(id, name);
            if (t == null) {
                return;
            }
            List<AbstractProcessVariable> tmpVars = this.createVarsFromStateChangedMessage(event.getMessage());
            t.getTopStackFrame().addVariables(tmpVars);
        }
        catch (DebugException e) {
            logger.error("cant handle StateChangeMessage");
            e.printStackTrace();
        }
    }

    private ProcessThread addThreadIfNotExists(String id, String name) {
        ProcessThread t = new ProcessThread(this, id, name);
        if (!this.threads.contains((Object)t)) {
            this.threads.add(t);
            t.fireCreationEvent();
            return t;
        }
        return this.getThreadById(id);
    }

    private ProcessThread getThreadById(String id) {
        Optional<ProcessThread> thread = this.threads.stream().filter(t -> t.getVicciProcessId().equals(id)).findFirst();
        if (thread.isPresent()) {
            return thread.get();
        }
        return null;
    }

    private void handleTerminated() {
        this.state = DebugTargetState.TERMINATED;
        this.dispatcher.terminate();
        this.fireTerminateEvent();
    }

    private List<AbstractProcessVariable> createVarsFromStateChangedMessage(IStateChangeMessage message) throws DebugException {
        ArrayList<AbstractProcessVariable> tmpVars = new ArrayList<AbstractProcessVariable>();
        this.addStateVariable(tmpVars, message);
        this.addEndDataPorts(tmpVars, message);
        this.addStartDataPorts(tmpVars, message);
        this.addStartControlPorts(tmpVars, message);
        this.addEndControlPorts(tmpVars, message);
        return tmpVars;
    }

    private void addStartControlPorts(List<AbstractProcessVariable> vars, IStateChangeMessage message) throws DebugException {
        if (!message.getStartControlPorts().isEmpty()) {
            this.addControlPortsList(vars, message.getStartControlPorts(), "startControlPorts");
        }
    }

    private void addEndControlPorts(List<AbstractProcessVariable> vars, IStateChangeMessage message) throws DebugException {
        if (!message.getEndControlPorts().isEmpty()) {
            this.addControlPortsList(vars, message.getEndControlPorts(), "endControlPorts");
        }
    }

    private void addStartDataPorts(List<AbstractProcessVariable> vars, IStateChangeMessage message) throws DebugException {
        if (!message.getStartDataPorts().isEmpty()) {
            this.addDataPortList(vars, message.getStartDataPorts(), "startDataPorts");
        }
    }

    private void addEndDataPorts(List<AbstractProcessVariable> vars, IStateChangeMessage message) throws DebugException {
        if (!message.getEndDataPorts().isEmpty()) {
            this.addDataPortList(vars, message.getEndDataPorts(), "endDataPorts");
        }
    }

    private void addDataPortList(List<AbstractProcessVariable> vars, Map<String, IJSONDataPortInstance> ports, String name) throws DebugException {
        PortListVariable portsList = new PortListVariable(this, name);
        for (Map.Entry<String, IJSONDataPortInstance> port : ports.entrySet()) {
            PortVariable portVar = new PortVariable(this, port.getValue().getName());
            StringVariable id = new StringVariable(this, "id");
            id.setValue(port.getKey());
            StateVariable state = new StateVariable(this, "state");
            state.setValue(port.getValue().getExecutionState().toString());
            ((PortValue)portVar.getValue()).addVariable(id);
            ((PortValue)portVar.getValue()).addVariable(state);
            this.addDataTypeInfos((PortValue)portVar.getValue(), port.getValue());
            ((PortListValue)portsList.getValue()).addVariable(portVar);
        }
        vars.add(portsList);
    }

    private void addControlPortsList(List<AbstractProcessVariable> vars, Map<String, IJSONPortInstance> ports, String name) throws DebugException {
        PortListVariable portsList = new PortListVariable(this, name);
        for (Map.Entry<String, IJSONPortInstance> port : ports.entrySet()) {
            PortVariable portVar = new PortVariable(this, port.getValue().getName());
            StringVariable id = new StringVariable(this, "id");
            id.setValue(port.getKey());
            StateVariable state = new StateVariable(this, "state");
            state.setValue(port.getValue().getExecutionState().toString());
            ((PortValue)portVar.getValue()).addVariable(id);
            ((PortValue)portVar.getValue()).addVariable(state);
            ((PortListValue)portsList.getValue()).addVariable(portVar);
        }
        vars.add(portsList);
    }

    private void addDataTypeInfos(PortValue portValue, IJSONDataPortInstance dto) throws DebugException {
        StringVariable tmpStringVar = new StringVariable(this, "TypeInstanceName");
        tmpStringVar.setValue(dto.getDataTypeInstance().getName());
        portValue.addVariable(tmpStringVar);
        tmpStringVar = new StringVariable(this, "value");
        tmpStringVar.setValue(dto.getDataTypeInstance().getValueString());
        portValue.addVariable(tmpStringVar);
    }

    private void addStateVariable(List<AbstractProcessVariable> vars, IStateChangeMessage message) {
        StateVariable processState = new StateVariable(this, "state");
        processState.setValue(message.getState().toString());
        vars.add(processState);
    }

    private static enum DebugTargetState {
        NOT_STARTED,
        SUSPENDED,
        RESUMED,
        TERMINATED,
        DISCONNECTED;

    }
}

