/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.adapter.wizard;

import eu.vicci.process.model.sofiainstance.BooleanTypeInstance;
import eu.vicci.process.model.sofiainstance.ComplexTypeInstance;
import eu.vicci.process.model.sofiainstance.DataTypeInstance;
import eu.vicci.process.model.sofiainstance.DoubleTypeInstance;
import eu.vicci.process.model.sofiainstance.IntegerTypeInstance;
import eu.vicci.process.model.sofiainstance.StringTypeInstance;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class DataTypePage
extends WizardPage {
    private static final String LBL_VALUE = "Value";
    private static final String LBL_ID = "Instance ID";
    private static final String LBL_MISSING = "ERROR: DT NAME IS MISSING";
    private Set<Control> errors = new HashSet<Control>();
    private static final String ERROR_STR = "ERROR";
    private static final String ERROR_NOT_IMPL = "DataType not implemented yet";

    protected DataTypePage(String pageName) {
        super(pageName);
    }

    public abstract List<DataTypeInstance> getDataTypeInstances();

    protected Composite addDtField(DataTypeInstance dt, Composite parent) {
        return this.addDtField(dt, parent, true);
    }

    protected Composite addDtField(DataTypeInstance dt, Composite parent, boolean inGroup) {
        if (dt instanceof StringTypeInstance) {
            return this.addStringField((StringTypeInstance)dt, parent);
        }
        if (dt instanceof IntegerTypeInstance) {
            return this.addIntField((IntegerTypeInstance)dt, parent);
        }
        if (dt instanceof DoubleTypeInstance) {
            return this.addDoubleField((DoubleTypeInstance)dt, parent);
        }
        if (dt instanceof BooleanTypeInstance) {
            return this.addBooleanField((BooleanTypeInstance)dt, parent);
        }
        if (dt instanceof ComplexTypeInstance) {
            return this.addComplexField((ComplexTypeInstance)dt, parent, !inGroup);
        }
        return this.addNotImplementedDataType(dt, parent, inGroup);
    }

    private Composite addComplexField(ComplexTypeInstance dt, Composite parent, boolean inExpandBar) {
        Composite container = inExpandBar ? parent : this.createGroupContainer((DataTypeInstance)dt, parent);
        ExpandBar expandBar = this.createExpandBarContainer((DataTypeInstance)dt, container);
        FillLayout layout2 = new FillLayout();
        layout2.type = 512;
        container.setLayout((Layout)layout2);
        dt.getSubtypes().stream().forEach(st -> this.addComplexItem((DataTypeInstance)st, expandBar, inExpandBar));
        return container;
    }

    private void addComplexItem(DataTypeInstance dt, ExpandBar parent, boolean inExpandBar) {
        Composite control = this.addDtField(dt, (Composite)parent, !inExpandBar);
        ExpandItem item = new ExpandItem(parent, 0);
        item.setText(dt.getName() == null ? LBL_MISSING : dt.getName());
        item.setHeight(control.computeSize((int)-1, (int)-1).y);
        item.setControl((Control)control);
        item.setExpanded(false);
    }

    public boolean canFlipToNextPage() {
        return this.errors.isEmpty();
    }

    private Composite addBooleanField(final BooleanTypeInstance dt, Composite parent) {
        Group container = this.createGroupContainer((DataTypeInstance)dt, parent);
        GridLayout layout = this.createGridLayout();
        container.setLayout((Layout)layout);
        this.addValueLabel((DataTypeInstance)dt, (Composite)container);
        final Button btn = new Button((Composite)container, 32);
        btn.setLayoutData((Object)this.createFieldGridData());
        btn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                dt.setValue(btn.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.addTypeAndInstanceInformation((DataTypeInstance)dt, (Composite)container);
        return container;
    }

    private Composite addIntField(IntegerTypeInstance dt, Composite parent) {
        Group container = this.createGroupContainer((DataTypeInstance)dt, parent);
        GridLayout layout = this.createGridLayout();
        container.setLayout((Layout)layout);
        this.addValueLabel((DataTypeInstance)dt, (Composite)container);
        Text txt = new Text((Composite)container, 2048);
        txt.setText(Integer.toString(dt.getValue()));
        txt.setLayoutData((Object)this.createFieldGridData());
        txt.addModifyListener(event -> {
            Integer v = this.parseInt(txt.getText());
            if (v == null) {
                txt.setBackground(this.getShell().getDisplay().getSystemColor(3));
                this.addError((Control)txt);
            } else {
                this.removeError((Control)txt);
                txt.setBackground(this.getShell().getDisplay().getSystemColor(1));
                dt.setValue(v.intValue());
            }
        });
        this.addTypeAndInstanceInformation((DataTypeInstance)dt, (Composite)container);
        return container;
    }

    private void addError(Control control) {
        this.errors.add(control);
        this.getWizard().getContainer().updateButtons();
    }

    private void removeError(Control control) {
        this.errors.remove(control);
        this.getWizard().getContainer().updateButtons();
    }

    private Composite addDoubleField(DoubleTypeInstance dt, Composite parent) {
        Group container = this.createGroupContainer((DataTypeInstance)dt, parent);
        GridLayout layout = this.createGridLayout();
        container.setLayout((Layout)layout);
        this.addValueLabel((DataTypeInstance)dt, (Composite)container);
        Text txt = new Text((Composite)container, 2048);
        txt.setText(Double.toString(dt.getValue()));
        txt.setLayoutData((Object)this.createFieldGridData());
        txt.addModifyListener(event -> {
            Double v = this.parseDouble(txt.getText());
            if (v == null) {
                txt.setBackground(this.getShell().getDisplay().getSystemColor(3));
                this.addError((Control)txt);
            } else {
                txt.setBackground(this.getShell().getDisplay().getSystemColor(1));
                dt.setValue(v.doubleValue());
                this.removeError((Control)txt);
            }
        });
        this.addTypeAndInstanceInformation((DataTypeInstance)dt, (Composite)container);
        return container;
    }

    private Composite addStringField(StringTypeInstance dt, Composite parent) {
        Group container = this.createGroupContainer((DataTypeInstance)dt, parent);
        GridLayout layout = this.createGridLayout();
        container.setLayout((Layout)layout);
        this.addValueLabel((DataTypeInstance)dt, (Composite)container);
        Text txt = new Text((Composite)container, 2048);
        txt.setText(dt.getValue() == null ? "" : dt.getValue());
        txt.setLayoutData((Object)this.createFieldGridData());
        txt.addModifyListener(event -> dt.setValue(txt.getText()));
        this.addTypeAndInstanceInformation((DataTypeInstance)dt, (Composite)container);
        return container;
    }

    private void addValueLabel(DataTypeInstance dt, Composite parent) {
        Label lbl = new Label(parent, 0);
        lbl.setText(LBL_VALUE);
    }

    private GridLayout createGridLayout() {
        GridLayout layout = new GridLayout(2, false);
        return layout;
    }

    private GridData createLblGridData() {
        GridData data = new GridData();
        return data;
    }

    private GridData createFieldGridData() {
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        return data;
    }

    private void addTypeAndInstanceInformation(DataTypeInstance dt, Composite parent) {
        Label type = new Label(parent, 0);
        type.setText(LBL_ID);
        type.setLayoutData((Object)this.createLblGridData());
        Text instanceId = new Text(parent, 2048);
        instanceId.setText(dt.getInstanceId());
        instanceId.setLayoutData((Object)this.createFieldGridData());
        instanceId.setEnabled(false);
    }

    private Group createGroupContainer(DataTypeInstance dt, Composite parent) {
        Group group = new Group(parent, 16);
        String name = dt.getName() == null ? LBL_MISSING : dt.getName();
        group.setText(name);
        return group;
    }

    private ExpandBar createExpandBarContainer(DataTypeInstance dt, Composite parent) {
        ExpandBar expandBar = new ExpandBar(parent, 512);
        return expandBar;
    }

    private Integer parseInt(String text) {
        Integer out = null;
        try {
            out = Integer.parseInt(text);
        }
        catch (NumberFormatException numberFormatException) {}
        return out;
    }

    private Double parseDouble(String text) {
        Double out = null;
        try {
            out = Double.parseDouble(text);
        }
        catch (NumberFormatException numberFormatException) {}
        return out;
    }

    private Composite addNotImplementedDataType(DataTypeInstance dt, Composite parent, boolean inGroup) {
        Group container = this.createGroupContainer(dt, parent);
        GridLayout layout = this.createGridLayout();
        container.setLayout((Layout)layout);
        Label lbl = new Label((Composite)container, 0);
        lbl.setText(ERROR_STR);
        Text txt = new Text((Composite)container, 2048);
        txt.setText(ERROR_NOT_IMPL);
        txt.setEditable(false);
        txt.setBackground(new Color(null, 255, 0, 0));
        this.addError((Control)txt);
        return container;
    }
}

